/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.bean.DeclaredMembers;

public final class CompositeBeanHelper {
    private static final Type[] NO_TYPES = new Type[0];
    private final ConverterLookup lookup;
    private final ClassLoader loader;
    private final ExpressionEvaluator evaluator;
    private final ConfigurationListener listener;

    public CompositeBeanHelper(ConverterLookup lookup2, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) {
        this.lookup = lookup2;
        this.loader = loader2;
        this.evaluator = evaluator;
        this.listener = listener;
    }

    public void setDefault(Object bean, Object defaultValue2, PlexusConfiguration configuration) throws ComponentConfigurationException {
        Type[] paramTypeHolder;
        Class<?> beanType = bean.getClass();
        Method setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set");
        if (setter == null) {
            throw new ComponentConfigurationException(configuration, "Cannot find default setter in " + beanType);
        }
        Object value2 = defaultValue2;
        TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
        if (!paramType.getRawType().isInstance(value2)) {
            if (configuration.getChildCount() > 0) {
                throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
            }
            value2 = this.convertProperty(beanType, paramType.getRawType(), paramType.getType(), configuration);
        }
        if (value2 != null) {
            try {
                if (this.listener != null) {
                    this.listener.notifyFieldChangeUsingSetter("", value2, bean);
                }
                setter.invoke(bean, value2);
            }
            catch (Exception e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
            catch (LinkageError e) {
                throw new ComponentConfigurationException(configuration, "Cannot set default", e);
            }
        }
    }

    public void setProperty(Object bean, String propertyName, Class<?> valueType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        String reason;
        Field field;
        Throwable problem2;
        Method setter;
        Class<?> beanType;
        block20: {
            String title;
            Type[] paramTypeHolder;
            beanType = bean.getClass();
            setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder = new Type[1], "set" + (title = String.valueOf(Character.toTitleCase(propertyName.charAt(0))) + propertyName.substring(1)));
            if (setter == null) {
                setter = CompositeBeanHelper.findMethod(beanType, paramTypeHolder, "add" + title);
            }
            problem2 = null;
            Object value2 = null;
            if (setter != null) {
                try {
                    TypeLiteral<?> paramType = TypeLiteral.get(paramTypeHolder[0]);
                    Class<?> rawPropertyType = paramType.getRawType();
                    if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                        rawPropertyType = valueType;
                    }
                    if ((value2 = this.convertProperty(beanType, rawPropertyType, paramType.getType(), configuration)) != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingSetter(propertyName, value2, bean);
                        }
                        setter.invoke(bean, value2);
                        return;
                    }
                }
                catch (Exception e) {
                    problem2 = e;
                }
                catch (LinkageError e) {
                    problem2 = e;
                }
            }
            if ((field = CompositeBeanHelper.findField(beanType, propertyName)) != null) {
                try {
                    TypeLiteral<?> fieldType = TypeLiteral.get(field.getGenericType());
                    Class<?> rawPropertyType = fieldType.getRawType();
                    if (!rawPropertyType.isInstance(value2)) {
                        if (valueType != null && rawPropertyType.isAssignableFrom(valueType)) {
                            rawPropertyType = valueType;
                        }
                        value2 = this.convertProperty(beanType, rawPropertyType, fieldType.getType(), configuration);
                    }
                    if (value2 != null) {
                        if (this.listener != null) {
                            this.listener.notifyFieldChangeUsingReflection(propertyName, value2, bean);
                        }
                        CompositeBeanHelper.setField(bean, field, value2);
                        return;
                    }
                }
                catch (Exception e) {
                    if (problem2 == null) {
                        problem2 = e;
                    }
                }
                catch (LinkageError e) {
                    if (problem2 != null) break block20;
                    problem2 = e;
                }
            }
        }
        if (problem2 instanceof ComponentConfigurationException) {
            throw (ComponentConfigurationException)problem2;
        }
        if (problem2 != null) {
            reason = "Cannot set '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason, problem2);
        }
        if (setter == null && field == null) {
            reason = "Cannot find '" + propertyName + "' in " + beanType;
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    private Object convertProperty(Class<?> beanType, Class<?> rawPropertyType, Type genericPropertyType, PlexusConfiguration configuration) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookup.lookupConverterForType(rawPropertyType);
        if (!(genericPropertyType instanceof Class) && converter instanceof ParameterizedConfigurationConverter) {
            Type[] propertyTypeArgs = CompositeBeanHelper.getTypeArguments(genericPropertyType);
            return ((ParameterizedConfigurationConverter)converter).fromConfiguration(this.lookup, configuration, rawPropertyType, propertyTypeArgs, beanType, this.loader, this.evaluator, this.listener);
        }
        return converter.fromConfiguration(this.lookup, configuration, rawPropertyType, beanType, this.loader, this.evaluator, this.listener);
    }

    private static Type[] getTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                typeArguments[i] = CompositeBeanHelper.expandType(typeArguments[i]);
                ++i;
            }
            return typeArguments;
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{CompositeBeanHelper.expandType(((GenericArrayType)type).getGenericComponentType())};
        }
        return NO_TYPES;
    }

    private static Type expandType(Type type) {
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getBounds()[0];
        }
        return type;
    }

    private static Method findMethod(Class<?> beanType, Type[] paramTypeHolder, String methodName) {
        Method[] methodArray = beanType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] paramTypes2;
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && !Modifier.isStatic(m.getModifiers()) && (paramTypes2 = m.getGenericParameterTypes()).length == 1) {
                paramTypeHolder[0] = paramTypes2[0];
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static Field findField(Class<?> beanType, String fieldName) {
        for (Member f2 : new DeclaredMembers(beanType, DeclaredMembers.View.FIELDS)) {
            if (!fieldName.equals(f2.getName()) || Modifier.isStatic(f2.getModifiers())) continue;
            return (Field)f2;
        }
        return null;
    }

    private static void setField(Object bean, final Field field, Object value2) throws Exception {
        if (!field.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
        field.set(bean, value2);
    }
}

