/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractPatternDependencyFilter
implements DependencyFilter {
    private final Set<String> patterns = new HashSet<String>();
    private final VersionScheme versionScheme;

    public AbstractPatternDependencyFilter(String ... patterns2) {
        this((VersionScheme)null, patterns2);
    }

    public AbstractPatternDependencyFilter(VersionScheme versionScheme, String ... patterns2) {
        this(versionScheme, patterns2 == null ? null : Arrays.asList(patterns2));
    }

    public AbstractPatternDependencyFilter(Collection<String> patterns2) {
        this(null, patterns2);
    }

    public AbstractPatternDependencyFilter(VersionScheme versionScheme, Collection<String> patterns2) {
        if (patterns2 != null) {
            this.patterns.addAll(patterns2);
        }
        this.versionScheme = versionScheme;
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents2) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        return this.accept(dependency.getArtifact());
    }

    protected boolean accept(Artifact artifact) {
        for (String pattern : this.patterns) {
            boolean matched = this.accept(artifact, pattern);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String pattern) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getBaseVersion()};
        String[] patternTokens = pattern.split(":");
        boolean matched = patternTokens.length <= tokens.length;
        for (int i = 0; matched && i < patternTokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    private boolean matches(String token2, String pattern) {
        boolean matches2;
        if ("*".equals(pattern) || pattern.length() == 0) {
            matches2 = true;
        } else if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains2 = pattern.substring(1, pattern.length() - 1);
            matches2 = token2.contains(contains2);
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1, pattern.length());
            matches2 = token2.endsWith(suffix);
        } else if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches2 = token2.startsWith(prefix);
        } else {
            matches2 = pattern.startsWith("[") || pattern.startsWith("(") ? this.isVersionIncludedInRange(token2, pattern) : token2.equals(pattern);
        }
        return matches2;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        if (this.versionScheme == null) {
            return false;
        }
        try {
            Version parsedVersion = this.versionScheme.parseVersion(version);
            VersionRange parsedRange = this.versionScheme.parseVersionRange(range);
            return parsedRange.containsVersion(parsedVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractPatternDependencyFilter that = (AbstractPatternDependencyFilter)obj;
        return this.patterns.equals(that.patterns) && (this.versionScheme == null ? that.versionScheme == null : this.versionScheme.equals(that.versionScheme));
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + this.patterns.hashCode();
        hash2 = hash2 * 31 + (this.versionScheme == null ? 0 : this.versionScheme.hashCode());
        return hash2;
    }
}

