/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Object getObject(Map<?, ?> properties, Object defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 == null) continue;
            return value2;
        }
        return defaultValue2;
    }

    public static Object getObject(RepositorySystemSession session, Object defaultValue2, String ... keys) {
        return ConfigUtils.getObject(session.getConfigProperties(), defaultValue2, keys);
    }

    public static String getString(Map<?, ?> properties, String defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (!(value2 instanceof String)) continue;
            return (String)value2;
        }
        return defaultValue2;
    }

    public static String getString(RepositorySystemSession session, String defaultValue2, String ... keys) {
        return ConfigUtils.getString(session.getConfigProperties(), defaultValue2, keys);
    }

    public static int getInteger(Map<?, ?> properties, int defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).intValue();
            }
            try {
                return Integer.valueOf((String)value2);
            }
            catch (Exception e) {
            }
        }
        return defaultValue2;
    }

    public static int getInteger(RepositorySystemSession session, int defaultValue2, String ... keys) {
        return ConfigUtils.getInteger(session.getConfigProperties(), defaultValue2, keys);
    }

    public static long getLong(Map<?, ?> properties, long defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).longValue();
            }
            try {
                return Long.valueOf((String)value2);
            }
            catch (Exception e) {
            }
        }
        return defaultValue2;
    }

    public static long getLong(RepositorySystemSession session, long defaultValue2, String ... keys) {
        return ConfigUtils.getLong(session.getConfigProperties(), defaultValue2, keys);
    }

    public static float getFloat(Map<?, ?> properties, float defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).floatValue();
            }
            try {
                return Float.valueOf((String)value2).floatValue();
            }
            catch (Exception e) {
            }
        }
        return defaultValue2;
    }

    public static float getFloat(RepositorySystemSession session, float defaultValue2, String ... keys) {
        return ConfigUtils.getFloat(session.getConfigProperties(), defaultValue2, keys);
    }

    public static boolean getBoolean(Map<?, ?> properties, boolean defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 instanceof Boolean) {
                return (Boolean)value2;
            }
            if (!(value2 instanceof String)) continue;
            return Boolean.parseBoolean((String)value2);
        }
        return defaultValue2;
    }

    public static boolean getBoolean(RepositorySystemSession session, boolean defaultValue2, String ... keys) {
        return ConfigUtils.getBoolean(session.getConfigProperties(), defaultValue2, keys);
    }

    public static List<?> getList(Map<?, ?> properties, List<?> defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (value2 instanceof List) {
                return (List)value2;
            }
            if (!(value2 instanceof Collection)) continue;
            return Collections.unmodifiableList(new ArrayList((Collection)value2));
        }
        return defaultValue2;
    }

    public static List<?> getList(RepositorySystemSession session, List<?> defaultValue2, String ... keys) {
        return ConfigUtils.getList(session.getConfigProperties(), defaultValue2, keys);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties, Map<?, ?> defaultValue2, String ... keys) {
        for (String key : keys) {
            Object value2 = properties.get(key);
            if (!(value2 instanceof Map)) continue;
            return (Map)value2;
        }
        return defaultValue2;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session, Map<?, ?> defaultValue2, String ... keys) {
        return ConfigUtils.getMap(session.getConfigProperties(), defaultValue2, keys);
    }
}

