/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File checksumFile) throws IOException {
        String checksum;
        block18: {
            checksum = "";
            FileInputStream fis = new FileInputStream(checksumFile);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"), 512);
                try {
                    String line2;
                    do {
                        if ((line2 = br.readLine()) != null) continue;
                        break block18;
                    } while ((line2 = line2.trim()).length() <= 0);
                    checksum = line2;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String algo : algos) {
            try {
                digests.put(algo, MessageDigest.getInstance(algo));
            }
            catch (NoSuchAlgorithmException e) {
                results.put(algo, e);
            }
        }
        FileInputStream fis = new FileInputStream(dataFile);
        try {
            int read2;
            byte[] buffer = new byte[32768];
            block10: while ((read2 = fis.read(buffer)) >= 0) {
                Iterator i$ = digests.values().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block10;
                    MessageDigest digest = (MessageDigest)i$.next();
                    digest.update(buffer, 0, read2);
                }
                break;
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
        for (Map.Entry entry2 : digests.entrySet()) {
            byte[] bytes2 = ((MessageDigest)entry2.getValue()).digest();
            results.put((String)entry2.getKey(), ChecksumUtils.toHexString(bytes2));
        }
        return results;
    }

    public static String toHexString(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes2.length * 2);
        for (byte aByte : bytes2) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }
}

