/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactDescriptorResult {
    private final ArtifactDescriptorRequest request;
    private List<Exception> exceptions;
    private List<Artifact> relocations;
    private Collection<Artifact> aliases;
    private Artifact artifact;
    private ArtifactRepository repository;
    private List<Dependency> dependencies;
    private List<Dependency> managedDependencies;
    private List<RemoteRepository> repositories;
    private Map<String, Object> properties;

    public ArtifactDescriptorResult(ArtifactDescriptorRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("artifact descriptor request has not been specified");
        }
        this.request = request;
        this.artifact = request.getArtifact();
        this.exceptions = Collections.emptyList();
        this.relocations = Collections.emptyList();
        this.aliases = Collections.emptyList();
        this.managedDependencies = Collections.emptyList();
        this.dependencies = this.managedDependencies;
        this.repositories = Collections.emptyList();
        this.properties = Collections.emptyMap();
    }

    public ArtifactDescriptorRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactDescriptorResult setExceptions(List<Exception> exceptions2) {
        this.exceptions = exceptions2 == null ? Collections.emptyList() : exceptions2;
        return this;
    }

    public ArtifactDescriptorResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public ArtifactDescriptorResult setRelocations(List<Artifact> relocations) {
        this.relocations = relocations == null ? Collections.emptyList() : relocations;
        return this;
    }

    public ArtifactDescriptorResult addRelocation(Artifact artifact) {
        if (artifact != null) {
            if (this.relocations.isEmpty()) {
                this.relocations = new ArrayList<Artifact>();
            }
            this.relocations.add(artifact);
        }
        return this;
    }

    public Collection<Artifact> getAliases() {
        return this.aliases;
    }

    public ArtifactDescriptorResult setAliases(Collection<Artifact> aliases2) {
        this.aliases = aliases2 == null ? Collections.emptyList() : aliases2;
        return this;
    }

    public ArtifactDescriptorResult addAlias(Artifact alias) {
        if (alias != null) {
            if (this.aliases.isEmpty()) {
                this.aliases = new ArrayList<Artifact>();
            }
            this.aliases.add(alias);
        }
        return this;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactDescriptorResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactDescriptorResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ArtifactDescriptorResult setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies == null ? Collections.emptyList() : dependencies;
        return this;
    }

    public ArtifactDescriptorResult addDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(dependency);
        }
        return this;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public ArtifactDescriptorResult setManagedDependencies(List<Dependency> dependencies) {
        this.managedDependencies = dependencies == null ? Collections.emptyList() : dependencies;
        return this;
    }

    public ArtifactDescriptorResult addManagedDependency(Dependency dependency) {
        if (dependency != null) {
            if (this.managedDependencies.isEmpty()) {
                this.managedDependencies = new ArrayList<Dependency>();
            }
            this.managedDependencies.add(dependency);
        }
        return this;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public ArtifactDescriptorResult setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories == null ? Collections.emptyList() : repositories;
        return this;
    }

    public ArtifactDescriptorResult addRepository(RemoteRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new ArrayList<RemoteRepository>();
            }
            this.repositories.add(repository);
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ArtifactDescriptorResult setProperties(Map<String, Object> properties) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
        return this;
    }

    public String toString() {
        return this.getArtifact() + " -> " + this.getDependencies();
    }
}

