/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class SimpleDigest {
    private MessageDigest digest;
    private long hash;

    public SimpleDigest() {
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ne) {
                this.digest = null;
                this.hash = 13L;
            }
        }
    }

    public void update(String data) {
        if (data == null || data.length() <= 0) {
            return;
        }
        if (this.digest != null) {
            try {
                this.digest.update(data.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            this.hash = this.hash * 31L + (long)data.hashCode();
        }
    }

    public String digest() {
        if (this.digest != null) {
            byte[] bytes2;
            StringBuilder buffer = new StringBuilder(64);
            for (byte aByte : bytes2 = this.digest.digest()) {
                int b = aByte & 0xFF;
                if (b < 16) {
                    buffer.append('0');
                }
                buffer.append(Integer.toHexString(b));
            }
            return buffer.toString();
        }
        return Long.toHexString(this.hash);
    }
}

