/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    private static final String CONFIG_PROP_SNAPSHOT_NORMALIZATION = "aether.artifactResolver.snapshotNormalization";
    private Logger logger = NullLoggerFactory.LOGGER;
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private VersionResolver versionResolver;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultArtifactResolver() {
    }

    @Inject
    DefaultArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultArtifactResolver setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        if (repositoryConnectorProvider == null) {
            throw new IllegalArgumentException("repository connector provider has not been specified");
        }
        this.repositoryConnectorProvider = repositoryConnectorProvider;
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        if (offlineController == null) {
            throw new IllegalArgumentException("offline controller has not been specified");
        }
        this.offlineController = offlineController;
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session, Collections.singleton(request)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        SyncContext syncContext = this.syncContextFactory.newInstance(session, false);
        try {
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list2 = this.resolve(session, requests);
            return list2;
        }
        finally {
            syncContext.close();
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        WorkspaceReader workspace = session.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file;
            VersionResult versionResult;
            RequestTrace trace2 = RequestTrace.newChild(artifactRequest.getTrace(), artifactRequest);
            ArtifactResult result2 = new ArtifactResult(artifactRequest);
            results.add(result2);
            Artifact artifact = artifactRequest.getArtifact();
            List<RemoteRepository> repos = artifactRequest.getRepositories();
            this.artifactResolving(session, trace2, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file2 = new File(localPath);
                if (!file2.isFile()) {
                    failures = true;
                    result2.addException(new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file2);
                result2.setArtifact(artifact);
                this.artifactResolved(session, trace2, artifact, null, result2.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace2);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
            }
            catch (VersionResolutionException e) {
                result2.addException(e);
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file);
                result2.setArtifact(artifact);
                result2.setRepository(workspace.getRepository());
                this.artifactResolved(session, trace2, artifact, result2.getRepository(), null);
                continue;
            }
            LocalArtifactResult local2 = lrm.find(session, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local2, versionResult)) {
                if (local2.getRepository() != null) {
                    result2.setRepository(local2.getRepository());
                } else {
                    result2.setRepository(lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, local2.getFile()));
                    result2.setArtifact(artifact);
                    this.artifactResolved(session, trace2, artifact, result2.getRepository(), null);
                }
                catch (ArtifactTransferException e) {
                    result2.addException(e);
                }
                if (local2.isAvailable()) continue;
                lrm.add(session, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local2.getFile() != null) {
                this.logger.debug("Verifying availability of " + local2.getFile() + " from " + repos);
            }
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups.iterator();
            for (RemoteRepository repo : repos) {
                if (!repo.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    Utils.checkOffline(session, this.offlineController, repo);
                }
                catch (RepositoryOfflineException e) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, repo, "Cannot access " + repo.getId() + " (" + repo.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", e);
                    result2.addException(exception);
                    continue;
                }
                ResolutionGroup group2 = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(repo)) continue;
                    group2 = t;
                    break;
                }
                if (group2 == null) {
                    group2 = new ResolutionGroup(repo);
                    groups.add(group2);
                    groupIt = Collections.emptyList().iterator();
                }
                group2.items.add(new ResolutionItem(trace2, artifact, resolved, result2, local2, repo));
            }
        }
        for (ResolutionGroup resolutionGroup : groups) {
            this.performDownloads(session, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException(exception);
            }
            RequestTrace trace3 = RequestTrace.newChild(request.getTrace(), request);
            this.artifactResolved(session, trace3, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session, Artifact artifact, File file) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean(session, true, CONFIG_PROP_SNAPSHOT_NORMALIZATION)) {
            boolean copy2;
            String name = file.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file.getParent(), name);
            boolean bl = copy2 = dst.length() != file.length() || dst.lastModified() != file.lastModified();
            if (copy2) {
                try {
                    this.fileProcessor.copy(file, dst);
                    dst.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    throw new ArtifactTransferException(artifact, null, e);
                }
            }
            file = dst;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDownloads(RepositorySystemSession session, ResolutionGroup group2) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session, group2);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download2 : downloads) {
            this.artifactDownloading(session, download2.getTrace(), download2.getArtifact(), group2.repository);
        }
        try {
            RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session, group2.repository);
            try {
                connector.get(downloads, null);
            }
            finally {
                connector.close();
            }
        }
        catch (NoRepositoryConnectorException e) {
            for (ArtifactDownload download3 : downloads) {
                download3.setException(new ArtifactTransferException(download3.getArtifact(), group2.repository, e));
            }
        }
        this.evaluateDownloads(session, group2);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session, ResolutionGroup group2) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group2.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download2 = new ArtifactDownload();
            download2.setArtifact(artifact);
            download2.setRequestContext(item.request.getRequestContext());
            download2.setListener(SafeTransferListener.wrap(session, this.logger));
            download2.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download2.setFile(item.local.getFile());
                download2.setExistenceCheck(true);
            } else {
                String path2 = lrm.getPathForRemoteArtifact(artifact, group2.repository, item.request.getRequestContext());
                download2.setFile(new File(lrm.getRepository().getBasedir(), path2));
            }
            boolean snapshot2 = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session, group2.repository, !snapshot2, snapshot2);
            int errorPolicy = Utils.getPolicy(session, artifact, group2.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check2 = new UpdateCheck<Artifact, ArtifactTransferException>();
                check2.setItem(artifact);
                check2.setFile(download2.getFile());
                check2.setFileValid(false);
                check2.setRepository(group2.repository);
                check2.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check2;
                this.updateCheckManager.checkArtifact(session, check2);
                if (!check2.isRequired()) {
                    item.result.addException(check2.getException());
                    continue;
                }
            }
            download2.setChecksumPolicy(policy.getChecksumPolicy());
            download2.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download2);
            item.download = download2;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session, ResolutionGroup group2) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        for (ResolutionItem item : group2.items) {
            ArtifactDownload download2 = item.download;
            if (download2 == null) continue;
            Artifact artifact = download2.getArtifact();
            if (download2.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository(group2.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, download2.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session, new LocalArtifactRegistration(artifact, group2.repository, download2.getSupportedContexts()));
                }
                catch (ArtifactTransferException e) {
                    download2.setException(e);
                    item.result.addException(e);
                }
            } else {
                item.result.addException(download2.getException());
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download2.getException());
                this.updateCheckManager.touchArtifact(session, item.updateCheck);
            }
            this.artifactDownloaded(session, download2.getTrace(), artifact, group2.repository, download2.getException());
            if (download2.getException() != null) continue;
            this.artifactResolved(session, download2.getTrace(), artifact, group2.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session, RequestTrace trace2, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace2);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session, RequestTrace trace2, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions2) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace2);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions2);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session, RequestTrace trace2, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace2);
        event.setArtifact(artifact);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session, RequestTrace trace2, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace2);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace2, Artifact artifact, AtomicBoolean resolved, ArtifactResult result2, LocalArtifactResult local2, RemoteRepository repository) {
            this.trace = trace2;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result2;
            this.request = result2.getRequest();
            this.local = local2;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

