/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(Reader reader) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, true);
    }

    public static Xpp3Dom build(InputStream is, String encoding) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(is, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(InputStream is, String encoding, boolean trim2) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(is, encoding);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim2);
            is.close();
            is = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(Reader reader, boolean trim2) throws XmlPullParserException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser, trim2);
            reader.close();
            reader = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    public static Xpp3Dom build(XmlPullParser parser) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser, true);
    }

    public static Xpp3Dom build(XmlPullParser parser, boolean trim2) throws XmlPullParserException, IOException {
        ArrayList<Xpp3Dom> elements2 = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuilder> values2 = new ArrayList<StringBuilder>();
        int eventType = parser.getEventType();
        boolean spacePreserve = false;
        while (eventType != 1) {
            if (eventType == 2) {
                spacePreserve = false;
                String rawName = parser.getName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements2.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements2.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements2.add(childConfiguration);
                if (parser.isEmptyElementTag()) {
                    values2.add(null);
                } else {
                    values2.add(new StringBuilder());
                }
                int attributesSize = parser.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = parser.getAttributeName(i);
                    String value2 = parser.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value2);
                    spacePreserve = spacePreserve || "xml:space".equals(name) && "preserve".equals(value2);
                }
            } else if (eventType == 4) {
                int depth = values2.size() - 1;
                StringBuilder valueBuffer = (StringBuilder)values2.get(depth);
                String text2 = parser.getText();
                if (trim2 && !spacePreserve) {
                    text2 = text2.trim();
                }
                valueBuffer.append(text2);
            } else if (eventType == 3) {
                int depth = elements2.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements2.remove(depth);
                Object accumulatedValue = values2.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }
}

