/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XmlWriterUtil {
    public static final String LS = System.getProperty("line.separator");
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_COLUMN_LINE = 80;

    public static void writeLineBreak(XMLWriter writer) {
        XmlWriterUtil.writeLineBreak(writer, 1);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat) {
        for (int i = 0; i < repeat; ++i) {
            writer.writeMarkup(LS);
        }
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent2) {
        XmlWriterUtil.writeLineBreak(writer, repeat, indent2, 2);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent2, int indentSize) {
        XmlWriterUtil.writeLineBreak(writer, repeat);
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        writer.writeText(StringUtils.repeat(" ", indent2 * indentSize));
    }

    public static void writeCommentLineBreak(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak(writer, 80);
    }

    public static void writeCommentLineBreak(XMLWriter writer, int columnSize) {
        if (columnSize < 10) {
            columnSize = 80;
        }
        writer.writeMarkup("<!-- " + StringUtils.repeat("=", columnSize - 10) + " -->" + LS);
    }

    public static void writeComment(XMLWriter writer, String comment2) {
        XmlWriterUtil.writeComment(writer, comment2, 0, 2);
    }

    public static void writeComment(XMLWriter writer, String comment2, int indent2) {
        XmlWriterUtil.writeComment(writer, comment2, indent2, 2);
    }

    public static void writeComment(XMLWriter writer, String comment2, int indent2, int indentSize) {
        XmlWriterUtil.writeComment(writer, comment2, indent2, indentSize, 80);
    }

    public static void writeComment(XMLWriter writer, String comment2, int indent2, int indentSize, int columnSize) {
        if (comment2 == null) {
            comment2 = "null";
        }
        while (comment2.contains("<!--")) {
            comment2 = comment2.replace("<!--", "");
        }
        while (comment2.contains("-->")) {
            comment2 = comment2.replace("-->", "");
        }
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        String indentation2 = StringUtils.repeat(" ", indent2 * indentSize);
        int magicNumber = indentation2.length() + columnSize - "-->".length() - 1;
        String[] sentences = StringUtils.split(comment2, LS);
        StringBuffer line2 = new StringBuffer(indentation2 + "<!-- ");
        for (String sentence : sentences) {
            String[] words2;
            for (String word : words2 = StringUtils.split(sentence, " ")) {
                StringBuilder sentenceTmp = new StringBuilder(line2.toString());
                sentenceTmp.append(word).append(' ');
                if (sentenceTmp.length() > magicNumber) {
                    if (line2.length() != indentation2.length() + "<!-- ".length()) {
                        if (magicNumber - line2.length() > 0) {
                            line2.append(StringUtils.repeat(" ", magicNumber - line2.length()));
                        }
                        line2.append("-->").append(LS);
                        writer.writeMarkup(line2.toString());
                    }
                    line2 = new StringBuffer(indentation2 + "<!-- ");
                    line2.append(word).append(' ');
                    continue;
                }
                line2.append(word).append(' ');
            }
            if (magicNumber - line2.length() <= 0) continue;
            line2.append(StringUtils.repeat(" ", magicNumber - line2.length()));
        }
        if (line2.length() <= magicNumber) {
            line2.append(StringUtils.repeat(" ", magicNumber - line2.length()));
        }
        line2.append("-->").append(LS);
        writer.writeMarkup(line2.toString());
    }

    public static void writeCommentText(XMLWriter writer, String comment2) {
        XmlWriterUtil.writeCommentText(writer, comment2, 0, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment2, int indent2) {
        XmlWriterUtil.writeCommentText(writer, comment2, indent2, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment2, int indent2, int indentSize) {
        XmlWriterUtil.writeCommentText(writer, comment2, indent2, indentSize, 80);
    }

    public static void writeCommentText(XMLWriter writer, String comment2, int indent2, int indentSize, int columnSize) {
        if (indent2 < 0) {
            indent2 = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        XmlWriterUtil.writeLineBreak(writer, 1);
        writer.writeMarkup(StringUtils.repeat(" ", indent2 * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeComment(writer, comment2, indent2, indentSize, columnSize);
        writer.writeMarkup(StringUtils.repeat(" ", indent2 * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeLineBreak(writer, 1, indent2, indentSize);
    }
}

