/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import org.codehaus.plexus.util.introspection.MethodMap;

public class ClassMap {
    private static final CacheMiss CACHE_MISS = new CacheMiss();
    private static final Object OBJECT = new Object();
    private final Class clazz;
    private Map<String, Object> methodCache = new Hashtable<String, Object>();
    private final MethodMap methodMap = new MethodMap();

    public ClassMap(Class clazz2) {
        this.clazz = clazz2;
        this.populateMethodCache();
    }

    Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params2) throws MethodMap.AmbiguousException {
        String methodKey = ClassMap.makeMethodKey(name, params2);
        Object cacheEntry = this.methodCache.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = this.methodMap.find(name, params2);
            }
            catch (MethodMap.AmbiguousException ae) {
                this.methodCache.put(methodKey, CACHE_MISS);
                throw ae;
            }
            if (cacheEntry == null) {
                this.methodCache.put(methodKey, CACHE_MISS);
            } else {
                this.methodCache.put(methodKey, cacheEntry);
            }
        }
        return (Method)cacheEntry;
    }

    private void populateMethodCache() {
        Method[] methods2;
        for (Method method : methods2 = ClassMap.getAccessibleMethods(this.clazz)) {
            Method publicMethod = ClassMap.getPublicMethod(method);
            if (publicMethod == null) continue;
            this.methodMap.add(publicMethod);
            this.methodCache.put(this.makeMethodKey(publicMethod), publicMethod);
        }
    }

    private String makeMethodKey(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuilder methodKey = new StringBuilder(method.getName());
        for (Class<?> parameterType : parameterTypes) {
            if (parameterType.isPrimitive()) {
                if (parameterType.equals(Boolean.TYPE)) {
                    methodKey.append("java.lang.Boolean");
                    continue;
                }
                if (parameterType.equals(Byte.TYPE)) {
                    methodKey.append("java.lang.Byte");
                    continue;
                }
                if (parameterType.equals(Character.TYPE)) {
                    methodKey.append("java.lang.Character");
                    continue;
                }
                if (parameterType.equals(Double.TYPE)) {
                    methodKey.append("java.lang.Double");
                    continue;
                }
                if (parameterType.equals(Float.TYPE)) {
                    methodKey.append("java.lang.Float");
                    continue;
                }
                if (parameterType.equals(Integer.TYPE)) {
                    methodKey.append("java.lang.Integer");
                    continue;
                }
                if (parameterType.equals(Long.TYPE)) {
                    methodKey.append("java.lang.Long");
                    continue;
                }
                if (!parameterType.equals(Short.TYPE)) continue;
                methodKey.append("java.lang.Short");
                continue;
            }
            methodKey.append(parameterType.getName());
        }
        return methodKey.toString();
    }

    private static String makeMethodKey(String method, Object[] params2) {
        StringBuilder methodKey = new StringBuilder().append(method);
        for (Object param2 : params2) {
            Object arg = param2;
            if (arg == null) {
                arg = OBJECT;
            }
            methodKey.append(arg.getClass().getName());
        }
        return methodKey.toString();
    }

    private static Method[] getAccessibleMethods(Class clazz2) {
        Method[] methods2 = clazz2.getMethods();
        if (Modifier.isPublic(clazz2.getModifiers())) {
            return methods2;
        }
        MethodInfo[] methodInfos = new MethodInfo[methods2.length];
        int i = methods2.length;
        while (i-- > 0) {
            methodInfos[i] = new MethodInfo(methods2[i]);
        }
        int upcastCount = ClassMap.getAccessibleMethods(clazz2, methodInfos, 0);
        if (upcastCount < methods2.length) {
            methods2 = new Method[upcastCount];
        }
        int j = 0;
        for (MethodInfo methodInfo : methodInfos) {
            if (!methodInfo.upcast) continue;
            methods2[j++] = methodInfo.method;
        }
        return methods2;
    }

    private static int getAccessibleMethods(Class clazz2, MethodInfo[] methodInfos, int upcastCount) {
        Class superclazz;
        int l = methodInfos.length;
        if (Modifier.isPublic(clazz2.getModifiers())) {
            for (int i = 0; i < l && upcastCount < l; ++i) {
                try {
                    MethodInfo methodInfo = methodInfos[i];
                    if (methodInfo.upcast) continue;
                    methodInfo.tryUpcasting(clazz2);
                    ++upcastCount;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (upcastCount == l) {
                return upcastCount;
            }
        }
        if ((superclazz = clazz2.getSuperclass()) != null && (upcastCount = ClassMap.getAccessibleMethods(superclazz, methodInfos, upcastCount)) == l) {
            return upcastCount;
        }
        Class<?>[] interfaces2 = clazz2.getInterfaces();
        int i = interfaces2.length;
        while (i-- > 0) {
            if ((upcastCount = ClassMap.getAccessibleMethods(interfaces2[i], methodInfos, upcastCount)) != l) continue;
            return upcastCount;
        }
        return upcastCount;
    }

    public static Method getPublicMethod(Method method) {
        Class<?> clazz2 = method.getDeclaringClass();
        if ((clazz2.getModifiers() & 1) != 0) {
            return method;
        }
        return ClassMap.getPublicMethod(clazz2, method.getName(), method.getParameterTypes());
    }

    private static Method getPublicMethod(Class clazz2, String name, Class[] paramTypes2) {
        Class<?>[] interfaces2;
        Method superclazzMethod;
        if ((clazz2.getModifiers() & 1) != 0) {
            try {
                return clazz2.getMethod(name, paramTypes2);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Class superclazz = clazz2.getSuperclass();
        if (superclazz != null && (superclazzMethod = ClassMap.getPublicMethod(superclazz, name, paramTypes2)) != null) {
            return superclazzMethod;
        }
        for (Class<?> anInterface : interfaces2 = clazz2.getInterfaces()) {
            Method interfaceMethod = ClassMap.getPublicMethod(anInterface, name, paramTypes2);
            if (interfaceMethod == null) continue;
            return interfaceMethod;
        }
        return null;
    }

    private static final class MethodInfo {
        Method method = null;
        String name;
        Class[] parameterTypes;
        boolean upcast;

        MethodInfo(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.upcast = false;
        }

        void tryUpcasting(Class clazz2) throws NoSuchMethodException {
            this.method = clazz2.getMethod(this.name, this.parameterTypes);
            this.name = null;
            this.parameterTypes = null;
            this.upcast = true;
        }
    }

    private static final class CacheMiss {
        private CacheMiss() {
        }
    }
}

