/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging.console;

import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;

public final class ConsoleLogger
extends AbstractLogger {
    private static final String[] TAGS = new String[]{"[DEBUG] ", "[INFO] ", "[WARNING] ", "[ERROR] ", "[FATAL ERROR] "};

    public ConsoleLogger(int threshold, String name) {
        super(threshold, name);
    }

    public ConsoleLogger() {
        this(1, "console");
    }

    @Override
    public void debug(String message, Throwable throwable2) {
        if (this.isDebugEnabled()) {
            ConsoleLogger.log(0, message, throwable2);
        }
    }

    @Override
    public void info(String message, Throwable throwable2) {
        if (this.isInfoEnabled()) {
            ConsoleLogger.log(1, message, throwable2);
        }
    }

    @Override
    public void warn(String message, Throwable throwable2) {
        if (this.isWarnEnabled()) {
            ConsoleLogger.log(2, message, throwable2);
        }
    }

    @Override
    public void error(String message, Throwable throwable2) {
        if (this.isErrorEnabled()) {
            ConsoleLogger.log(3, message, throwable2);
        }
    }

    @Override
    public void fatalError(String message, Throwable throwable2) {
        if (this.isFatalErrorEnabled()) {
            ConsoleLogger.log(4, message, throwable2);
        }
    }

    @Override
    public Logger getChildLogger(String name) {
        return this;
    }

    private static void log(int level, String message, Throwable throwable2) {
        System.out.println(TAGS[level].concat(message));
        if (throwable2 != null) {
            throwable2.printStackTrace(System.out);
        }
    }
}

