/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation.reflection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.codehaus.plexus.interpolation.reflection.ClassMap;
import org.codehaus.plexus.interpolation.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, WeakReference<ClassMap>> classMaps = new WeakHashMap();

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(String expression, Object root2) throws Exception {
        return ReflectionValueExtractor.evaluate(expression, root2, true);
    }

    public static Object evaluate(String expression, Object root2, boolean trimRootToken) throws Exception {
        if (trimRootToken) {
            expression = expression.substring(expression.indexOf(46) + 1);
        }
        Object value2 = root2;
        StringTokenizer parser = new StringTokenizer(expression, ".");
        while (parser.hasMoreTokens()) {
            String token2 = parser.nextToken();
            if (value2 == null) {
                return null;
            }
            ClassMap classMap = ReflectionValueExtractor.getClassMap(value2.getClass());
            String methodBase = StringUtils.capitalizeFirstLetter(token2);
            String methodName = "get" + methodBase;
            Method method = classMap.findMethod(methodName, CLASS_ARGS);
            if (method == null) {
                methodName = "is" + methodBase;
                method = classMap.findMethod(methodName, CLASS_ARGS);
            }
            if (method == null) {
                return null;
            }
            value2 = method.invoke(value2, OBJECT_ARGS);
        }
        return value2;
    }

    private static ClassMap getClassMap(Class<?> clazz2) {
        ClassMap classMap;
        WeakReference<ClassMap> ref2 = classMaps.get(clazz2);
        if (ref2 == null || (classMap = (ClassMap)ref2.get()) == null) {
            classMap = new ClassMap(clazz2);
            classMaps.put(clazz2, new WeakReference<ClassMap>(classMap));
        }
        return classMap;
    }
}

