/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.interpolation.InterpolationCycleException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.multi.DelimiterSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDelimiterStringSearchInterpolator
implements Interpolator {
    private static final int MAX_TRIES = 10;
    private Map existingAnswers = new HashMap();
    private List<ValueSource> valueSources = new ArrayList<ValueSource>();
    private List postProcessors = new ArrayList();
    private boolean cacheAnswers = false;
    private LinkedHashSet<DelimiterSpecification> delimiters = new LinkedHashSet();
    private String escapeString;

    public MultiDelimiterStringSearchInterpolator() {
        this.delimiters.add(DelimiterSpecification.DEFAULT_SPEC);
    }

    public MultiDelimiterStringSearchInterpolator addDelimiterSpec(String delimiterSpec) {
        if (delimiterSpec == null) {
            return this;
        }
        this.delimiters.add(DelimiterSpecification.parse(delimiterSpec));
        return this;
    }

    public boolean removeDelimiterSpec(String delimiterSpec) {
        if (delimiterSpec == null) {
            return false;
        }
        return this.delimiters.remove(DelimiterSpecification.parse(delimiterSpec));
    }

    public MultiDelimiterStringSearchInterpolator withValueSource(ValueSource vs) {
        this.addValueSource(vs);
        return this;
    }

    public MultiDelimiterStringSearchInterpolator withPostProcessor(InterpolationPostProcessor postProcessor) {
        this.addPostProcessor(postProcessor);
        return this;
    }

    @Override
    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    @Override
    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    @Override
    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    @Override
    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    @Override
    public String interpolate(String input2, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input2, new SimpleRecursionInterceptor());
    }

    @Override
    public String interpolate(String input2, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input2, recursionInterceptor);
    }

    @Override
    public String interpolate(String input2) throws InterpolationException {
        return this.interpolate(input2, new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpolate(String input2, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string2 = this.interpolate(input2, recursionInterceptor, new HashSet<String>());
            return string2;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    private String interpolate(String input2, RecursionInterceptor recursionInterceptor, Set<String> unresolvable) throws InterpolationException {
        if (input2 == null) {
            return "";
        }
        StringBuilder result2 = new StringBuilder(input2.length() * 2);
        String lastResult2 = input2;
        int tries = 0;
        do {
            ++tries;
            if (result2.length() > 0) {
                lastResult2 = result2.toString();
                result2.setLength(0);
            }
            int startIdx = -1;
            int endIdx = -1;
            DelimiterSpecification selectedSpec = null;
            while ((selectedSpec = this.select(input2, endIdx)) != null) {
                String startExpr = selectedSpec.getBegin();
                String endExpr = selectedSpec.getEnd();
                startIdx = selectedSpec.getNextStartIndex();
                result2.append(input2, endIdx + 1, startIdx);
                endIdx = input2.indexOf(endExpr, startIdx + 1);
                if (endIdx < 0) break;
                String wholeExpr = input2.substring(startIdx, endIdx + endExpr.length());
                String realExpr = wholeExpr.substring(startExpr.length(), wholeExpr.length() - endExpr.length());
                if (startIdx >= 0 && this.escapeString != null && this.escapeString.length() > 0) {
                    String escape2;
                    int startEscapeIdx;
                    int n = startEscapeIdx = startIdx == 0 ? 0 : startIdx - this.escapeString.length();
                    if (startEscapeIdx >= 0 && (escape2 = input2.substring(startEscapeIdx, startIdx)) != null && this.escapeString.equals(escape2)) {
                        result2.append(wholeExpr);
                        result2.replace(startEscapeIdx, startEscapeIdx + this.escapeString.length(), "");
                        continue;
                    }
                }
                boolean resolved = false;
                if (!unresolvable.contains(wholeExpr)) {
                    if (realExpr.startsWith(".")) {
                        realExpr = realExpr.substring(1);
                    }
                    if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    recursionInterceptor.expressionResolutionStarted(realExpr);
                    Object value2 = this.existingAnswers.get(realExpr);
                    Object bestAnswer = null;
                    for (ValueSource vs : this.valueSources) {
                        if (value2 != null) break;
                        value2 = vs.getValue(realExpr);
                        if (value2 == null || !value2.toString().contains(wholeExpr)) continue;
                        bestAnswer = value2;
                        value2 = null;
                    }
                    if (value2 == null && bestAnswer != null) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    if (value2 != null) {
                        value2 = this.interpolate(String.valueOf(value2), recursionInterceptor, unresolvable);
                        if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                            for (ValueSource postProcessor1 : this.postProcessors) {
                                InterpolationPostProcessor postProcessor = (InterpolationPostProcessor)((Object)postProcessor1);
                                Object newVal = postProcessor.execute(realExpr, value2);
                                if (newVal == null) continue;
                                value2 = newVal;
                                break;
                            }
                        }
                        result2.append(String.valueOf(value2));
                        resolved = true;
                    } else {
                        unresolvable.add(wholeExpr);
                    }
                    recursionInterceptor.expressionResolutionFinished(realExpr);
                }
                if (!resolved) {
                    result2.append(wholeExpr);
                }
                if (endIdx <= -1) continue;
                endIdx += endExpr.length() - 1;
            }
            if (endIdx == -1 && startIdx > -1) {
                result2.append(input2, startIdx, input2.length());
                continue;
            }
            if (endIdx >= input2.length()) continue;
            result2.append(input2, endIdx + 1, input2.length());
        } while (!lastResult2.equals(result2.toString()) && tries < 10);
        return result2.toString();
    }

    private DelimiterSpecification select(String input2, int lastEndIdx) {
        DelimiterSpecification selected = null;
        for (DelimiterSpecification spec : this.delimiters) {
            int idx;
            spec.clearNextStart();
            if (selected != null || (idx = input2.indexOf(spec.getBegin(), lastEndIdx + 1)) <= -1) continue;
            spec.setNextStartIndex(idx);
            selected = spec;
        }
        return selected;
    }

    @Override
    public List getFeedback() {
        ArrayList messages2 = new ArrayList();
        for (ValueSource vs : this.valueSources) {
            List feedback = vs.getFeedback();
            if (feedback == null || feedback.isEmpty()) continue;
            messages2.addAll(feedback);
        }
        return messages2;
    }

    @Override
    public void clearFeedback() {
        for (ValueSource vs : this.valueSources) {
            vs.clearFeedback();
        }
    }

    @Override
    public boolean isCacheAnswers() {
        return this.cacheAnswers;
    }

    @Override
    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }

    @Override
    public void clearAnswers() {
        this.existingAnswers.clear();
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public MultiDelimiterStringSearchInterpolator setDelimiterSpecs(LinkedHashSet<String> specs2) {
        this.delimiters.clear();
        for (String spec : specs2) {
            if (spec == null) continue;
            this.delimiters.add(DelimiterSpecification.parse(spec));
        }
        return this;
    }
}

