/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.interpolation.InterpolationCycleException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSearchInterpolator
implements Interpolator {
    private Map existingAnswers = new HashMap();
    private List<ValueSource> valueSources = new ArrayList<ValueSource>();
    private List<InterpolationPostProcessor> postProcessors = new ArrayList<InterpolationPostProcessor>();
    private boolean cacheAnswers = false;
    public static final String DEFAULT_START_EXPR = "${";
    public static final String DEFAULT_END_EXPR = "}";
    private String startExpr;
    private String endExpr;
    private String escapeString;

    public StringSearchInterpolator() {
        this.startExpr = DEFAULT_START_EXPR;
        this.endExpr = DEFAULT_END_EXPR;
    }

    public StringSearchInterpolator(String startExpr, String endExpr) {
        this.startExpr = startExpr;
        this.endExpr = endExpr;
    }

    @Override
    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    @Override
    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    @Override
    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    @Override
    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    @Override
    public String interpolate(String input2, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input2, new SimpleRecursionInterceptor());
    }

    @Override
    public String interpolate(String input2, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input2, recursionInterceptor);
    }

    @Override
    public String interpolate(String input2) throws InterpolationException {
        return this.interpolate(input2, new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpolate(String input2, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string2 = this.interpolate(input2, recursionInterceptor, new HashSet<String>());
            return string2;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String interpolate(String input2, RecursionInterceptor recursionInterceptor, Set<String> unresolvable) throws InterpolationException {
        int startIdx;
        if (input2 == null) {
            return "";
        }
        StringBuilder result2 = new StringBuilder(input2.length() * 2);
        int endIdx = -1;
        while ((startIdx = input2.indexOf(this.startExpr, endIdx + 1)) > -1) {
            result2.append(input2, endIdx + 1, startIdx);
            endIdx = input2.indexOf(this.endExpr, startIdx + 1);
            if (endIdx < 0) break;
            String wholeExpr = input2.substring(startIdx, endIdx + this.endExpr.length());
            String realExpr = wholeExpr.substring(this.startExpr.length(), wholeExpr.length() - this.endExpr.length());
            if (startIdx >= 0 && this.escapeString != null && this.escapeString.length() > 0) {
                String escape2;
                int startEscapeIdx;
                int n = startEscapeIdx = startIdx == 0 ? 0 : startIdx - this.escapeString.length();
                if (startEscapeIdx >= 0 && (escape2 = input2.substring(startEscapeIdx, startIdx)) != null && this.escapeString.equals(escape2)) {
                    result2.append(wholeExpr);
                    result2.replace(startEscapeIdx, startEscapeIdx + this.escapeString.length(), "");
                    continue;
                }
            }
            boolean resolved = false;
            if (!unresolvable.contains(wholeExpr)) {
                if (realExpr.startsWith(".")) {
                    realExpr = realExpr.substring(1);
                }
                if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                    throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                }
                recursionInterceptor.expressionResolutionStarted(realExpr);
                try {
                    Object value2 = this.existingAnswers.get(realExpr);
                    Object bestAnswer = null;
                    for (ValueSource valueSource : this.valueSources) {
                        if (value2 != null) break;
                        value2 = valueSource.getValue(realExpr);
                        if (value2 == null || !value2.toString().contains(wholeExpr)) continue;
                        bestAnswer = value2;
                        value2 = null;
                    }
                    if (value2 == null && bestAnswer != null) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    if (value2 != null) {
                        value2 = this.interpolate(String.valueOf(value2), recursionInterceptor, unresolvable);
                        if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                            for (InterpolationPostProcessor postProcessor : this.postProcessors) {
                                Object newVal = postProcessor.execute(realExpr, value2);
                                if (newVal == null) continue;
                                value2 = newVal;
                                break;
                            }
                        }
                        result2.append(String.valueOf(value2));
                        resolved = true;
                    } else {
                        unresolvable.add(wholeExpr);
                    }
                }
                finally {
                    recursionInterceptor.expressionResolutionFinished(realExpr);
                }
            }
            if (!resolved) {
                result2.append(wholeExpr);
            }
            if (endIdx <= -1) continue;
            endIdx += this.endExpr.length() - 1;
        }
        if (endIdx == -1 && startIdx > -1) {
            result2.append(input2, startIdx, input2.length());
        } else if (endIdx < input2.length()) {
            result2.append(input2, endIdx + 1, input2.length());
        }
        return result2.toString();
    }

    @Override
    public List getFeedback() {
        ArrayList messages2 = new ArrayList();
        for (ValueSource vs : this.valueSources) {
            List feedback = vs.getFeedback();
            if (feedback == null || feedback.isEmpty()) continue;
            messages2.addAll(feedback);
        }
        return messages2;
    }

    @Override
    public void clearFeedback() {
        for (ValueSource vs : this.valueSources) {
            vs.clearFeedback();
        }
    }

    @Override
    public boolean isCacheAnswers() {
        return this.cacheAnswers;
    }

    @Override
    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }

    @Override
    public void clearAnswers() {
        this.existingAnswers.clear();
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }
}

