/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.interpolation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.util.ValueSourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixAwareRecursionInterceptor
implements RecursionInterceptor {
    public static final String DEFAULT_START_TOKEN = "\\$\\{";
    public static final String DEFAULT_END_TOKEN = "\\}";
    private Stack<String> nakedExpressions = new Stack();
    private final String[] possiblePrefixes;
    private boolean watchUnprefixedExpressions = true;

    public PrefixAwareRecursionInterceptor(Collection<String> possiblePrefixes, boolean watchUnprefixedExpressions) {
        this.possiblePrefixes = possiblePrefixes.toArray(new String[possiblePrefixes.size()]);
        this.watchUnprefixedExpressions = watchUnprefixedExpressions;
    }

    public PrefixAwareRecursionInterceptor(Collection<String> possiblePrefixes) {
        this.possiblePrefixes = possiblePrefixes.toArray(new String[possiblePrefixes.size()]);
    }

    @Override
    public boolean hasRecursiveExpression(String expression) {
        String realExpr = ValueSourceUtils.trimPrefix(expression, this.possiblePrefixes, this.watchUnprefixedExpressions);
        return realExpr != null && this.nakedExpressions.contains(realExpr);
    }

    @Override
    public void expressionResolutionFinished(String expression) {
        this.nakedExpressions.pop();
    }

    @Override
    public void expressionResolutionStarted(String expression) {
        String realExpr = ValueSourceUtils.trimPrefix(expression, this.possiblePrefixes, this.watchUnprefixedExpressions);
        this.nakedExpressions.push(realExpr);
    }

    @Override
    public List getExpressionCycle(String expression) {
        String expr2 = ValueSourceUtils.trimPrefix(expression, this.possiblePrefixes, this.watchUnprefixedExpressions);
        if (expr2 == null) {
            return Collections.EMPTY_LIST;
        }
        int idx = this.nakedExpressions.indexOf(expr2);
        if (idx < 0) {
            return Collections.EMPTY_LIST;
        }
        return this.nakedExpressions.subList(idx, this.nakedExpressions.size());
    }
}

