/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.IOUtil;

public class FileConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "file-configuration-resource";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        PlexusConfiguration[] plexusConfigurationArray;
        File f2 = new File(this.getSource(parameters));
        if (!f2.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f2 + " cannot be found.");
        }
        FileReader configurationReader = null;
        try {
            configurationReader = new FileReader(f2);
            plexusConfigurationArray = new PlexusConfiguration[]{PlexusTools.buildConfiguration(f2.getAbsolutePath(), configurationReader)};
        }
        catch (PlexusConfigurationException e) {
            try {
                throw new ConfigurationProcessingException(e);
                catch (FileNotFoundException e2) {
                    throw new ConfigurationProcessingException(e2);
                }
            }
            catch (Throwable throwable2) {
                IOUtil.close(configurationReader);
                throw throwable2;
            }
        }
        IOUtil.close(configurationReader);
        return plexusConfigurationArray;
    }
}

