/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class DirectoryConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "directory-configuration-resource";
    }

    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        File f2 = new File(this.getSource(parameters));
        if (!f2.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f2 + " cannot be found.");
        }
        if (!f2.isDirectory()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f2 + " is not a directory.");
        }
        String includes2 = (String)parameters.get("includes");
        if (includes2 == null) {
            includes2 = "**/*.xml";
        }
        String excludes = (String)parameters.get("excludes");
        try {
            List<File> files2 = FileUtils.getFiles(f2, includes2, excludes);
            PlexusConfiguration[] configurations = new PlexusConfiguration[files2.size()];
            for (int i = 0; i < configurations.length; ++i) {
                PlexusConfiguration configuration;
                File configurationFile = files2.get(i);
                configurations[i] = configuration = PlexusTools.buildConfiguration(configurationFile.getAbsolutePath(), new FileReader(configurationFile));
            }
            return configurations;
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationProcessingException(e);
        }
        catch (IOException e) {
            throw new ConfigurationProcessingException(e);
        }
        catch (PlexusConfigurationException e) {
            throw new ConfigurationProcessingException(e);
        }
    }
}

