/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public class ConfigurationProcessor {
    protected Map handlers = new HashMap();

    public void addConfigurationResourceHandler(ConfigurationResourceHandler handler) {
        this.handlers.put(handler.getId(), handler);
    }

    public PlexusConfiguration process(PlexusConfiguration configuration, Map variables) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        XmlPlexusConfiguration processed = new XmlPlexusConfiguration("configuration");
        this.walk(configuration, processed, variables);
        return processed;
    }

    protected void walk(PlexusConfiguration source, PlexusConfiguration processed, Map variables) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        PlexusConfiguration[] children2 = source.getChildren();
        for (int i = 0; i < children2.length; ++i) {
            PlexusConfiguration child = children2[i];
            int count = child.getChildCount();
            if (count > 0) {
                XmlPlexusConfiguration processedChild = new XmlPlexusConfiguration(child.getName());
                this.copyAttributes(child, processedChild);
                processed.addChild(processedChild);
                this.walk(child, processedChild, variables);
                continue;
            }
            String elementName = child.getName();
            if (this.handlers.containsKey(elementName)) {
                ConfigurationResourceHandler handler = (ConfigurationResourceHandler)this.handlers.get(elementName);
                PlexusConfiguration[] configurations = handler.handleRequest(this.createHandlerParameters(child, variables));
                for (int j = 0; j < configurations.length; ++j) {
                    processed.addChild(configurations[j]);
                }
                continue;
            }
            processed.addChild(child);
        }
    }

    protected Map createHandlerParameters(PlexusConfiguration c, Map variables) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] parameterNames = c.getAttributeNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            String key = parameterNames[i];
            String value2 = StringUtils.interpolate(c.getAttribute(key, null), variables);
            parameters.put(key, value2);
        }
        return parameters;
    }

    private void copyAttributes(PlexusConfiguration source, XmlPlexusConfiguration target) {
        String[] names2 = source.getAttributeNames();
        for (int i = 0; i < names2.length; ++i) {
            target.setAttribute(names2[i], source.getAttribute(names2[i], null));
        }
    }
}

