/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.functions.ContentSupplier;
import org.codehaus.plexus.components.io.functions.NameSupplier;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.functions.SizeSupplier;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

class ResourceInvocationHandler
implements InvocationHandler {
    private PlexusIoResource testImpl;
    private final ContentSupplier contentSupplier;
    private final NameSupplier nameSupplier;
    private final SizeSupplier sizeSupplier;
    private final SymlinkDestinationSupplier symlinkDestinationSupplier;
    private final ResourceAttributeSupplier resourceAttributeSupplier;

    public ResourceInvocationHandler(@Nonnull PlexusIoResource target, Object alternativeHandler) {
        this.testImpl = target;
        this.contentSupplier = ResourceInvocationHandler.asOrNull(alternativeHandler, ContentSupplier.class);
        this.nameSupplier = ResourceInvocationHandler.asOrNull(alternativeHandler, NameSupplier.class);
        this.sizeSupplier = ResourceInvocationHandler.asOrNull(alternativeHandler, SizeSupplier.class);
        this.symlinkDestinationSupplier = ResourceInvocationHandler.asOrNull(alternativeHandler, SymlinkDestinationSupplier.class);
        this.resourceAttributeSupplier = ResourceInvocationHandler.asOrNull(alternativeHandler, ResourceAttributeSupplier.class);
    }

    private static <T> T asOrNull(Object instance, Class<T> clazz2) {
        if (instance != null && clazz2.isAssignableFrom(instance.getClass())) {
            return (T)instance;
        }
        return null;
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args2) throws Throwable {
        String name = method.getName();
        if (this.contentSupplier != null && "getContents".equals(name)) {
            return this.contentSupplier.getContents();
        }
        if (this.nameSupplier != null && "getName".equals(name)) {
            return this.nameSupplier.getName();
        }
        if (this.sizeSupplier != null && "getSize".equals(name)) {
            return this.sizeSupplier.getSize();
        }
        if (this.symlinkDestinationSupplier != null && "getSymlinkDestination".equals(name)) {
            return this.symlinkDestinationSupplier.getSymlinkDestination();
        }
        if (this.resourceAttributeSupplier != null && "getAttributes".equals(name)) {
            return this.resourceAttributeSupplier.getAttributes();
        }
        return method.invoke((Object)this.testImpl, args2);
    }
}

