/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import javax.annotation.Nullable;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;

public class SimpleResourceAttributes
implements PlexusIoResourceAttributes {
    private Integer gid;
    private Integer uid;
    private String userName;
    private String groupName;
    private int mode = -1;
    private boolean isSymbolicLink;

    public SimpleResourceAttributes(Integer uid, String userName, Integer gid, String groupName2, int mode) {
        this.uid = uid;
        this.userName = userName;
        this.gid = gid;
        this.groupName = groupName2;
        this.mode = mode;
    }

    public static PlexusIoResourceAttributes lastResortDummyAttributesForBrokenOS() {
        return new SimpleResourceAttributes();
    }

    SimpleResourceAttributes() {
    }

    @Override
    public int getOctalMode() {
        return this.mode;
    }

    @Override
    @Nullable
    public Integer getGroupId() {
        return this.gid;
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Integer getUserId() {
        return this.uid;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isGroupExecutable() {
        return PlexusIoResourceAttributeUtils.isGroupExecutableInOctal(this.mode);
    }

    @Override
    public boolean isGroupReadable() {
        return PlexusIoResourceAttributeUtils.isGroupReadableInOctal(this.mode);
    }

    @Override
    public boolean isGroupWritable() {
        return PlexusIoResourceAttributeUtils.isGroupWritableInOctal(this.mode);
    }

    @Override
    public boolean isOwnerExecutable() {
        return PlexusIoResourceAttributeUtils.isOwnerExecutableInOctal(this.mode);
    }

    @Override
    public boolean isOwnerReadable() {
        return PlexusIoResourceAttributeUtils.isOwnerReadableInOctal(this.mode);
    }

    @Override
    public boolean isOwnerWritable() {
        return PlexusIoResourceAttributeUtils.isOwnerWritableInOctal(this.mode);
    }

    @Override
    public boolean isWorldExecutable() {
        return PlexusIoResourceAttributeUtils.isWorldExecutableInOctal(this.mode);
    }

    @Override
    public boolean isWorldReadable() {
        return PlexusIoResourceAttributeUtils.isWorldReadableInOctal(this.mode);
    }

    @Override
    public boolean isWorldWritable() {
        return PlexusIoResourceAttributeUtils.isWorldWritableInOctal(this.mode);
    }

    public String getOctalModeString() {
        return Integer.toString(this.mode, 8);
    }

    public PlexusIoResourceAttributes setOctalMode(int mode) {
        this.mode = mode;
        return this;
    }

    public PlexusIoResourceAttributes setGroupId(Integer gid) {
        this.gid = gid;
        return this;
    }

    public PlexusIoResourceAttributes setGroupName(String name) {
        this.groupName = name;
        return this;
    }

    public PlexusIoResourceAttributes setUserId(Integer uid) {
        this.uid = uid;
        return this;
    }

    public PlexusIoResourceAttributes setUserName(String name) {
        this.userName = name;
        return this;
    }

    public PlexusIoResourceAttributes setOctalModeString(String mode) {
        this.setOctalMode(Integer.parseInt(mode, 8));
        return this;
    }

    public String toString() {
        return String.format("%nResource Attributes:%n------------------------------%nuser: %s%ngroup: %s%nuid: %d%ngid: %d%nmode: %06o", this.userName == null ? "" : this.userName, this.groupName == null ? "" : this.groupName, this.uid != null ? this.uid : 0, this.gid != null ? this.gid : 0, this.mode);
    }

    public void setSymbolicLink(boolean isSymbolicLink) {
        this.isSymbolicLink = isSymbolicLink;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.isSymbolicLink;
    }
}

