/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.util.FileUtils;

public final class PlexusIoResourceAttributeUtils {
    private PlexusIoResourceAttributeUtils() {
    }

    public static PlexusIoResourceAttributes mergeAttributes(PlexusIoResourceAttributes override, PlexusIoResourceAttributes base, PlexusIoResourceAttributes def) {
        SimpleResourceAttributes result2;
        if (override == null) {
            return base;
        }
        if (base == null) {
            result2 = new SimpleResourceAttributes();
        } else {
            result2 = new SimpleResourceAttributes(base.getUserId(), base.getUserName(), base.getGroupId(), base.getGroupName(), base.getOctalMode());
            result2.setSymbolicLink(base.isSymbolicLink());
        }
        if (override.getGroupId() != null && override.getGroupId() != -1) {
            result2.setGroupId(override.getGroupId());
        }
        if (def != null && def.getGroupId() >= 0 && (result2.getGroupId() == null || result2.getGroupId() < 0)) {
            result2.setGroupId(def.getGroupId());
        }
        if (override.getGroupName() != null) {
            result2.setGroupName(override.getGroupName());
        }
        if (def != null && result2.getGroupName() == null) {
            result2.setGroupName(def.getGroupName());
        }
        if (override.getUserId() != null && override.getUserId() != -1) {
            result2.setUserId(override.getUserId());
        }
        if (def != null && def.getUserId() >= 0 && (result2.getUserId() == null || result2.getUserId() < 0)) {
            result2.setUserId(def.getUserId());
        }
        if (override.getUserName() != null) {
            result2.setUserName(override.getUserName());
        }
        if (def != null && result2.getUserName() == null) {
            result2.setUserName(def.getUserName());
        }
        if (override.getOctalMode() > 0) {
            result2.setOctalMode(override.getOctalMode());
        }
        if (def != null && result2.getOctalMode() < 0) {
            result2.setOctalMode(def.getOctalMode());
        }
        return result2;
    }

    public static boolean isGroupExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 8);
    }

    public static boolean isGroupReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 32);
    }

    public static boolean isGroupWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 16);
    }

    public static boolean isOwnerExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 64);
    }

    public static boolean isOwnerReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 256);
    }

    public static boolean isOwnerWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 128);
    }

    public static boolean isWorldExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 1);
    }

    public static boolean isWorldReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 4);
    }

    public static boolean isWorldWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 2);
    }

    public static boolean isOctalModeEnabled(int mode, int targetMode) {
        return (mode & targetMode) != 0;
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file) throws IOException {
        Map<String, PlexusIoResourceAttributes> byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, false);
        PlexusIoResourceAttributes o = byPath.get(file.getAbsolutePath());
        if (o == null) {
            return SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
        }
        return o;
    }

    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(File dir) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, true);
    }

    @Nonnull
    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(@Nonnull File dir, boolean recursive) throws IOException {
        HashMap<Integer, String> userCache = new HashMap<Integer, String>();
        HashMap<Integer, String> groupCache = new HashMap<Integer, String>();
        List<String> fileAndDirectoryNames = recursive && dir.isDirectory() ? FileUtils.getFileAndDirectoryNames(dir, null, null, true, true, true, true) : Collections.singletonList(dir.getAbsolutePath());
        LinkedHashMap<String, PlexusIoResourceAttributes> attributesByPath = new LinkedHashMap<String, PlexusIoResourceAttributes>();
        for (String fileAndDirectoryName : fileAndDirectoryNames) {
            attributesByPath.put(fileAndDirectoryName, new FileAttributes(new File(fileAndDirectoryName), userCache, groupCache));
        }
        return attributesByPath;
    }
}

