/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration, evaluator, type);
        if (value2 != null) {
            return value2;
        }
        try {
            Properties properties = this.instantiateProperties(configuration, type, loader2);
            int i = 0;
            int size2 = configuration.getChildCount();
            while (i < size2) {
                PlexusConfiguration element = configuration.getChild(i);
                if ("property".equals(element.getName()) && element.getChildCount() > 0) {
                    Object name = this.fromExpression(element.getChild("name"), evaluator);
                    this.setProperty(properties, name, element.getChild("value"), evaluator);
                } else if (element.getChildCount() == 0) {
                    this.setProperty(properties, element.getName(), element, evaluator);
                }
                ++i;
            }
            return properties;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Properties instantiateProperties(PlexusConfiguration configuration, Class<?> type, ClassLoader loader2) throws ComponentConfigurationException {
        Class<?> implType2 = this.getClassForImplementationHint(type, configuration, loader2);
        if (implType2 == null || Modifier.isAbstract(implType2.getModifiers())) {
            return new Properties();
        }
        Object impl = this.instantiateObject(implType2);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Properties)impl;
    }

    private void setProperty(Properties properties, Object name, PlexusConfiguration valueConfiguration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String key;
        String string2 = key = name != null ? name.toString() : null;
        if (key == null) {
            throw new ComponentConfigurationException("Missing name in properties");
        }
        Object value2 = this.fromExpression(valueConfiguration, evaluator);
        properties.setProperty(key, value2 != null ? value2.toString() : "");
    }
}

