/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class CollectionConverter
extends AbstractCollectionConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup2, configuration, type, null, enclosingType, loader2, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value2)) {
            return value2;
        }
        try {
            Collection<Object> elements2;
            Class<?> elementType2 = CollectionConverter.findElementType(typeArguments);
            if (value2 == null) {
                elements2 = this.fromChildren(lookup2, configuration, type, enclosingType, loader2, evaluator, listener, elementType2);
            } else if (value2 instanceof String) {
                PlexusConfiguration xml = CollectionConverter.csvToXml(configuration, (String)value2);
                elements2 = this.fromChildren(lookup2, xml, type, enclosingType, loader2, evaluator, listener, elementType2);
            } else if (value2 instanceof Object[]) {
                elements2 = this.instantiateCollection(configuration, type, loader2);
                Collections.addAll(elements2, (Object[])value2);
            } else {
                this.failIfNotTypeCompatible(value2, type, configuration);
                elements2 = Collections.emptyList();
            }
            return elements2;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into collection", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader2) throws ComponentConfigurationException {
        Class<?> implType2 = this.getClassForImplementationHint(type, configuration, loader2);
        if (implType2 == null || Modifier.isAbstract(implType2.getModifiers())) {
            if (Set.class.isAssignableFrom(type)) {
                if (SortedSet.class.isAssignableFrom(type)) {
                    return new TreeSet<Object>();
                }
                return new HashSet<Object>();
            }
            return new ArrayList<Object>();
        }
        Object impl = this.instantiateObject(implType2);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Collection)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments) {
        if (typeArguments != null && typeArguments.length > 0 && typeArguments[0] instanceof Class) {
            return (Class)typeArguments[0];
        }
        return Object.class;
    }
}

