/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class ArrayConverter
extends AbstractCollectionConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value2)) {
            return value2;
        }
        try {
            Collection<Object> elements2;
            Class<?> elementType2 = type.getComponentType();
            if (value2 == null) {
                elements2 = this.fromChildren(lookup2, configuration, type, enclosingType, loader2, evaluator, listener, elementType2);
            } else if (value2 instanceof String) {
                PlexusConfiguration xml = ArrayConverter.csvToXml(configuration, (String)value2);
                elements2 = this.fromChildren(lookup2, xml, type, enclosingType, loader2, evaluator, listener, elementType2);
            } else if (value2 instanceof Collection) {
                elements2 = (Collection<Object>)value2;
            } else {
                this.failIfNotTypeCompatible(value2, type, configuration);
                elements2 = Collections.emptyList();
            }
            return elements2.toArray((Object[])Array.newInstance(elementType2, elements2.size()));
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into array", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader2) {
        return new ArrayList<Object>(configuration.getChildCount());
    }
}

