/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.basic;

import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public abstract class AbstractBasicConverter
extends AbstractConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
        }
        Object result2 = this.fromExpression(configuration, evaluator, type);
        if (result2 instanceof String) {
            try {
                result2 = this.fromString((String)result2);
            }
            catch (ComponentConfigurationException e) {
                if (e.getFailedConfiguration() == null) {
                    e.setFailedConfiguration(configuration);
                }
                throw e;
            }
        }
        return result2;
    }

    protected abstract Object fromString(String var1) throws ComponentConfigurationException;

    @Override
    protected final Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        String value2 = configuration.getValue();
        try {
            Object result2 = null;
            if (value2 != null && value2.length() > 0) {
                result2 = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value2, type) : evaluator.evaluate(value2);
            }
            if (result2 == null && (value2 = configuration.getAttribute("default-value")) != null && value2.length() > 0) {
                result2 = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value2, type) : evaluator.evaluate(value2);
            }
            return result2;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value2, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }
}

