/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import java.lang.reflect.Array;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.plexus.Roles;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader2, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup2, configuration, type, enclosingType, loader2, evaluator, null);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String value2 = configuration.getValue();
        try {
            Object result2 = null;
            if (value2 != null && value2.length() > 0) {
                result2 = evaluator.evaluate(value2);
            }
            if (result2 == null && configuration.getChildCount() == 0 && (value2 = configuration.getAttribute("default-value")) != null && value2.length() > 0) {
                result2 = evaluator.evaluate(value2);
            }
            return result2;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value2, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        Object result2 = this.fromExpression(configuration, evaluator);
        this.failIfNotTypeCompatible(result2, type, configuration);
        return result2;
    }

    protected final String fromXML(String name) {
        return Roles.camelizeName(name);
    }

    protected final void failIfNotTypeCompatible(Object value2, Class<?> type, PlexusConfiguration configuration) throws ComponentConfigurationException {
        if (value2 != null && type != null && !type.isInstance(value2)) {
            String reason = String.format("Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration.getName(), configuration.getValue(), value2.getClass().getCanonicalName(), type.getCanonicalName());
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type, PlexusConfiguration configuration, ClassLoader loader2) throws ComponentConfigurationException {
        String hint = configuration.getAttribute("implementation");
        if (hint == null) {
            return type;
        }
        try {
            int dims = 0;
            while (hint.endsWith("[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType2 = loader2.loadClass(hint);
            while (dims > 0) {
                implType2 = Array.newInstance(implType2, 0).getClass();
                --dims;
            }
            return implType2;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e);
        }
    }

    protected final Object instantiateObject(Class<?> type) throws ComponentConfigurationException {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, (Throwable)e);
        }
    }
}

