/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ConfigurationParser {
    public static final String MAIN_PREFIX = "main is";
    public static final String SET_PREFIX = "set";
    public static final String IMPORT_PREFIX = "import";
    public static final String LOAD_PREFIX = "load";
    public static final String OPTIONALLY_PREFIX = "optionally";
    private ConfigurationHandler handler;
    private Properties systemProperties;

    public ConfigurationParser(ConfigurationHandler handler, Properties systemProperties2) {
        this.handler = handler;
        this.systemProperties = systemProperties2;
    }

    public void parse(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line2 = null;
        int lineNo = 0;
        boolean mainSet = false;
        String curRealm = null;
        while ((line2 = reader.readLine()) != null) {
            ++lineNo;
            if (this.canIgnore(line2 = line2.trim())) continue;
            if (line2.startsWith(MAIN_PREFIX)) {
                if (mainSet) {
                    throw new ConfigurationException("Duplicate main configuration", lineNo, line2);
                }
                String conf = line2.substring(MAIN_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line2);
                }
                String mainClassName = this.filter(conf.substring(0, fromLoc).trim());
                String mainRealmName = this.filter(conf.substring(fromLoc + 4).trim());
                this.handler.setAppMain(mainClassName, mainRealmName);
                mainSet = true;
                continue;
            }
            if (line2.startsWith(SET_PREFIX)) {
                File propertiesFile;
                String value2;
                String conf = line2.substring(SET_PREFIX.length()).trim();
                int usingLoc = conf.indexOf(" using") + 1;
                String property = null;
                String propertiesFileName = null;
                if (usingLoc > 0) {
                    property = conf.substring(0, usingLoc).trim();
                    conf = propertiesFileName = this.filter(conf.substring(usingLoc + 5).trim());
                }
                String defaultValue2 = null;
                int defaultLoc = conf.indexOf(" default") + 1;
                if (defaultLoc > 0) {
                    defaultValue2 = this.filter(conf.substring(defaultLoc + 7).trim());
                    if (property == null) {
                        property = conf.substring(0, defaultLoc).trim();
                    } else {
                        propertiesFileName = conf.substring(0, defaultLoc).trim();
                    }
                }
                if ((value2 = this.systemProperties.getProperty(property)) != null) continue;
                if (propertiesFileName != null && (propertiesFile = new File(propertiesFileName)).exists()) {
                    Properties properties = new Properties();
                    try {
                        properties.load(new FileInputStream(propertiesFileName));
                        value2 = properties.getProperty(property);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (value2 == null && defaultValue2 != null) {
                    value2 = defaultValue2;
                }
                if (value2 == null) continue;
                value2 = this.filter(value2);
                this.systemProperties.setProperty(property, value2);
                continue;
            }
            if (line2.startsWith("[")) {
                int rbrack = line2.indexOf("]");
                if (rbrack < 0) {
                    throw new ConfigurationException("Invalid realm specifier", lineNo, line2);
                }
                String realmName = line2.substring(1, rbrack);
                this.handler.addRealm(realmName);
                curRealm = realmName;
                continue;
            }
            if (line2.startsWith(IMPORT_PREFIX)) {
                if (curRealm == null) {
                    throw new ConfigurationException("Unhandled import", lineNo, line2);
                }
                String conf = line2.substring(IMPORT_PREFIX.length()).trim();
                int fromLoc = conf.indexOf("from");
                if (fromLoc < 0) {
                    throw new ConfigurationException("Missing from clause", lineNo, line2);
                }
                String importSpec = conf.substring(0, fromLoc).trim();
                String relamName = conf.substring(fromLoc + 4).trim();
                this.handler.addImportFrom(relamName, importSpec);
                continue;
            }
            if (line2.startsWith(LOAD_PREFIX)) {
                String constituent = line2.substring(LOAD_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, false);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    this.handler.addLoadFile(file);
                    continue;
                }
                try {
                    this.handler.addLoadURL(new URL(constituent));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new FileNotFoundException(constituent);
                }
            }
            if (line2.startsWith(OPTIONALLY_PREFIX)) {
                String constituent = line2.substring(OPTIONALLY_PREFIX.length()).trim();
                if ((constituent = this.filter(constituent)).indexOf("*") >= 0) {
                    this.loadGlob(constituent, true);
                    continue;
                }
                File file = new File(constituent);
                if (file.exists()) {
                    this.handler.addLoadFile(file);
                    continue;
                }
                try {
                    this.handler.addLoadURL(new URL(constituent));
                }
                catch (MalformedURLException e) {}
                continue;
            }
            throw new ConfigurationException("Unhandled configuration", lineNo, line2);
        }
        reader.close();
    }

    protected void loadGlob(String line2, boolean optionally) throws MalformedURLException, FileNotFoundException, ConfigurationException {
        File[] matches2;
        File globFile = new File(line2);
        File dir = globFile.getParentFile();
        if (!dir.exists()) {
            if (optionally) {
                return;
            }
            throw new FileNotFoundException(dir.toString());
        }
        String localName = globFile.getName();
        int starLoc = localName.indexOf("*");
        final String prefix = localName.substring(0, starLoc);
        final String suffix = localName.substring(starLoc + 1);
        for (File match : matches2 = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(prefix)) {
                    return false;
                }
                return name.endsWith(suffix);
            }
        })) {
            this.handler.addLoadFile(match);
        }
    }

    protected String filter(String text2) throws ConfigurationException {
        String result2 = "";
        int cur = 0;
        int textLen = text2.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        while (cur < textLen && (propStart = text2.indexOf("${", cur)) >= 0) {
            result2 = result2 + text2.substring(cur, propStart);
            propStop = text2.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text2.substring(propStart));
            }
            propName = text2.substring(propStart + 2, propStop);
            propValue = this.systemProperties.getProperty(propName);
            if (propName.equals("basedir") && (propValue == null || propValue.equals(""))) {
                propValue = new File("").getAbsolutePath();
            }
            if (propValue == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result2 = result2 + propValue;
            cur = propStop + 1;
        }
        result2 = result2 + text2.substring(cur);
        return result2;
    }

    private boolean canIgnore(String line2) {
        return line2.length() == 0 || line2.startsWith("#");
    }
}

