/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";
    private Charset charset = Charset.forName("UTF-8");

    @Override
    public boolean isConcurrentAccessSupported() {
        return false;
    }

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f2 = this.getFile();
        if (f2 == null) {
            throw new IOException("The zip file has not been set.");
        }
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{f2.toURI().toURL()}, null){

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        URL url = new URL("jar:" + f2.toURI().toURL() + "!/");
        ZipFile zipFile2 = new ZipFile(f2, this.charset != null ? this.charset.name() : "UTF8");
        Enumeration<ZipArchiveEntry> en = zipFile2.getEntriesInPhysicalOrder();
        return new ZipFileResourceIterator(en, url, zipFile2, urlClassLoader);
    }

    @Override
    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    private static class ZipFileResourceIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        private final Enumeration<ZipArchiveEntry> en;
        private final URL url;
        private final ZipFile zipFile;
        private final URLClassLoader urlClassLoader;

        public ZipFileResourceIterator(Enumeration<ZipArchiveEntry> en, URL url, ZipFile zipFile2, URLClassLoader urlClassLoader) {
            this.en = en;
            this.url = url;
            this.zipFile = zipFile2;
            this.urlClassLoader = urlClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry2 = this.en.nextElement();
            return entry2.isUnixSymlink() ? new ZipFileSymlinkResource(entry2) : new ZipFileResource(entry2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            try {
                this.urlClassLoader.close();
            }
            finally {
                this.zipFile.close();
            }
        }

        private class ZipFileSymlinkResource
        extends ZipFileResource
        implements SymlinkDestinationSupplier {
            private final ZipArchiveEntry entry;

            private ZipFileSymlinkResource(ZipArchiveEntry entry2) {
                super(entry2);
                this.entry = entry2;
            }

            @Override
            public String getSymlinkDestination() throws IOException {
                return ZipFileResourceIterator.this.zipFile.getUnixSymlink(this.entry);
            }

            @Override
            public boolean isSymbolicLink() {
                return true;
            }
        }

        private class ZipFileResource
        extends PlexusIoURLResource {
            private ZipFileResource(ZipArchiveEntry entry2) {
                super(entry2.getName(), entry2.getTime() == -1L ? 0L : entry2.getTime(), entry2.isDirectory() ? -1L : entry2.getSize(), !entry2.isDirectory(), entry2.isDirectory(), true);
            }

            @Override
            public URL getURL() throws IOException {
                String spec = this.getName();
                if (spec.startsWith("/")) {
                    spec = "./" + spec;
                    return new URL(ZipFileResourceIterator.this.url, spec);
                }
                return ZipFileResourceIterator.this.urlClassLoader.getResource(spec);
            }
        }
    }
}

