/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipResource;
import org.codehaus.plexus.archiver.zip.ZipSymlinkResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.EncodingSupported;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class PlexusArchiverZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection
implements EncodingSupported {
    public static final String ROLE_HINT = "zip";
    private Charset charset = Charset.forName("UTF-8");

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f2 = this.getFile();
        if (f2 == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        ZipFile zipFile2 = new ZipFile(f2, this.charset != null ? this.charset.name() : "UTF8");
        return new CloseableIterator(zipFile2);
    }

    @Override
    public boolean isConcurrentAccessSupported() {
        return false;
    }

    @Override
    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    class CloseableIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        final Enumeration en;
        private final ZipFile zipFile;

        public CloseableIterator(ZipFile zipFile2) {
            this.en = zipFile2.getEntriesInPhysicalOrder();
            this.zipFile = zipFile2;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipArchiveEntry entry2 = (ZipArchiveEntry)this.en.nextElement();
            return entry2.isUnixSymlink() ? new ZipSymlinkResource(this.zipFile, entry2, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer()) : new ZipResource(this.zipFile, entry2, PlexusArchiverZipFileResourceCollection.this.getStreamTransformer());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

