/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;
import org.codehaus.plexus.archiver.zip.DeferredScatterOutputStream;
import org.codehaus.plexus.util.IOUtil;

public class ConcurrentJarCreator {
    private final boolean compressAddedZips;
    private final ScatterZipOutputStream directories;
    private final ScatterZipOutputStream metaInfDir;
    private final ScatterZipOutputStream manifest;
    private final ScatterZipOutputStream synchronousEntries;
    private final ParallelScatterZipCreator parallelScatterZipCreator;
    private long zipCloseElapsed;

    public static ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore bs = scatterGatherBackingStoreSupplier.get();
        StreamCompressor sc = StreamCompressor.create(-1, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    public ConcurrentJarCreator(int nThreads) throws IOException {
        this(true, nThreads);
    }

    public ConcurrentJarCreator(boolean compressAddedZips, int nThreads) throws IOException {
        this.compressAddedZips = compressAddedZips;
        DeferredSupplier defaultSupplier = new DeferredSupplier(100000000 / nThreads);
        this.directories = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.manifest = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.metaInfDir = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.synchronousEntries = ConcurrentJarCreator.createDeferred(defaultSupplier);
        this.parallelScatterZipCreator = new ParallelScatterZipCreator(Executors.newFixedThreadPool(nThreads), defaultSupplier);
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier source, boolean addInParallel) throws IOException {
        int method = zipArchiveEntry.getMethod();
        if (method == -1) {
            throw new IllegalArgumentException("Method must be set on the supplied zipArchiveEntry");
        }
        if (zipArchiveEntry.isDirectory() && !zipArchiveEntry.isUnixSymlink()) {
            ByteArrayInputStream payload = new ByteArrayInputStream(new byte[0]);
            this.directories.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, this.createInputStreamSupplier(payload)));
            payload.close();
        } else if ("META-INF".equals(zipArchiveEntry.getName()) || "META-INF/".equals(zipArchiveEntry.getName())) {
            InputStream payload = source.get();
            if (zipArchiveEntry.isDirectory()) {
                zipArchiveEntry.setMethod(0);
            }
            this.metaInfDir.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, this.createInputStreamSupplier(payload)));
            payload.close();
        } else if ("META-INF/MANIFEST.MF".equals(zipArchiveEntry.getName())) {
            InputStream payload = source.get();
            if (zipArchiveEntry.isDirectory()) {
                zipArchiveEntry.setMethod(0);
            }
            this.manifest.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, this.createInputStreamSupplier(payload)));
            payload.close();
        } else if (addInParallel) {
            this.parallelScatterZipCreator.addArchiveEntry(this.createEntrySupplier(zipArchiveEntry, source));
        } else {
            this.synchronousEntries.addArchiveEntry(this.createEntry(zipArchiveEntry, source));
        }
    }

    private InputStreamSupplier createInputStreamSupplier(final InputStream payload) {
        return new InputStreamSupplier(){

            @Override
            public InputStream get() {
                return payload;
            }
        };
    }

    public void writeTo(ZipArchiveOutputStream targetStream) throws IOException, ExecutionException, InterruptedException {
        this.metaInfDir.writeTo(targetStream);
        this.manifest.writeTo(targetStream);
        this.directories.writeTo(targetStream);
        this.synchronousEntries.writeTo(targetStream);
        this.parallelScatterZipCreator.writeTo(targetStream);
        long startAt = System.currentTimeMillis();
        targetStream.close();
        this.zipCloseElapsed = System.currentTimeMillis() - startAt;
        this.metaInfDir.close();
        this.manifest.close();
        this.directories.close();
        this.synchronousEntries.close();
    }

    public String getStatisticsMessage() {
        return this.parallelScatterZipCreator.getStatisticsMessage() + " Zip Close: " + this.zipCloseElapsed + "ms";
    }

    private ZipArchiveEntryRequestSupplier createEntrySupplier(final ZipArchiveEntry zipArchiveEntry, final InputStreamSupplier inputStreamSupplier) {
        return new ZipArchiveEntryRequestSupplier(){

            @Override
            public ZipArchiveEntryRequest get() {
                try {
                    return ConcurrentJarCreator.this.createEntry(zipArchiveEntry, inputStreamSupplier);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private ZipArchiveEntryRequest createEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier inputStreamSupplier) throws IOException {
        if (this.compressAddedZips) {
            return ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, inputStreamSupplier);
        }
        InputStream is = inputStreamSupplier.get();
        byte[] header = new byte[4];
        try {
            int read2 = is.read(header);
            int compressionMethod = zipArchiveEntry.getMethod();
            if (this.isZipHeader(header)) {
                compressionMethod = 0;
            }
            zipArchiveEntry.setMethod(compressionMethod);
            return ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, this.prependBytesToStream(header, read2, is));
        }
        catch (IOException e) {
            IOUtil.close(is);
            throw e;
        }
    }

    private boolean isZipHeader(byte[] header) {
        return header[0] == 80 && header[1] == 75 && header[2] == 3 && header[3] == 4;
    }

    private InputStreamSupplier prependBytesToStream(final byte[] bytes2, final int len, final InputStream stream) {
        return new InputStreamSupplier(){

            @Override
            public InputStream get() {
                return len > 0 ? new SequenceInputStream(new ByteArrayInputStream(bytes2, 0, len), stream) : stream;
            }
        };
    }

    private static class DeferredSupplier
    implements ScatterGatherBackingStoreSupplier {
        private int threshold;

        DeferredSupplier(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public ScatterGatherBackingStore get() throws IOException {
            return new DeferredScatterOutputStream(this.threshold);
        }
    }
}

