/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.Charsets;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.archiver.zip.AddedDirs;
import org.codehaus.plexus.archiver.zip.AnonymousResource;
import org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractZipArchiver
extends AbstractArchiver {
    private String comment;
    private String encoding = "UTF8";
    private boolean doCompress = true;
    private boolean recompressAddedZips = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean doFilesonly = false;
    protected final Hashtable<String, String> entries = new Hashtable();
    protected final AddedDirs addedDirs = new AddedDirs();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected final String duplicate = "skip";
    protected boolean addingNewFiles = false;
    private File renamedFile = null;
    private File zipFile;
    private boolean success;
    private ConcurrentJarCreator zOut;
    protected ZipArchiveOutputStream zipArchiveOutputStream;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment2) {
        this.comment = comment2;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public boolean isRecompressAddedZips() {
        return this.recompressAddedZips;
    }

    public void setRecompressAddedZips(boolean recompressAddedZips) {
        this.recompressAddedZips = recompressAddedZips;
    }

    public void setUpdateMode(boolean update2) {
        this.savedDoUpdate = this.doUpdate = update2;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void setFilesonly(boolean f2) {
        this.doFilesonly = f2;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    @Override
    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
        this.finalizeZipOutputStream(this.zOut);
    }

    protected void finalizeZipOutputStream(ConcurrentJarCreator zOut) throws IOException, ArchiverException {
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        ResourceIterator iter;
        if (!"skip".equals("skip")) {
            this.setDuplicateBehavior("skip");
        }
        if (!(iter = this.getResources()).hasNext() && !this.hasVirtualFiles()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        this.zipFile = this.getDestFile();
        if (this.zipFile == null) {
            throw new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new ArchiverException(this.zipFile + " isn't a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new ArchiverException(this.zipFile + " is read-only.");
        }
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        this.success = false;
        if (this.doUpdate) {
            this.renamedFile = FileUtils.createTempFile("zip", ".tmp", this.zipFile.getParentFile());
            this.renamedFile.deleteOnExit();
            try {
                FileUtils.rename(this.zipFile, this.renamedFile);
            }
            catch (SecurityException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
            catch (IOException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
        }
        String action2 = this.doUpdate ? "Updating " : "Building ";
        this.getLogger().info(action2 + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        if (!this.skipWriting) {
            this.zipArchiveOutputStream = new ZipArchiveOutputStream(Streams.bufferedOutputStream(Streams.fileOutputStream(this.zipFile, "zip")));
            this.zipArchiveOutputStream.setEncoding(this.encoding);
            this.zipArchiveOutputStream.setCreateUnicodeExtraFields(this.getUnicodeExtraFieldPolicy());
            this.zipArchiveOutputStream.setMethod(this.doCompress ? 8 : 0);
            this.zOut = new ConcurrentJarCreator(this.recompressAddedZips, Runtime.getRuntime().availableProcessors());
        }
        this.initZipOutputStream(this.zOut);
        this.addResources(iter, this.zOut);
        if (this.doUpdate && !this.renamedFile.delete()) {
            this.getLogger().warn("Warning: unable to delete temporary file " + this.renamedFile.getName());
        }
        this.success = true;
    }

    private ZipArchiveOutputStream.UnicodeExtraFieldPolicy getUnicodeExtraFieldPolicy() {
        boolean utf8;
        String effectiveEncoding = this.getEncoding();
        if (effectiveEncoding == null) {
            effectiveEncoding = Charset.defaultCharset().name();
        }
        if (!(utf8 = Charsets.UTF_8.name().equalsIgnoreCase(effectiveEncoding))) {
            for (String alias : Charsets.UTF_8.aliases()) {
                if (!alias.equalsIgnoreCase(effectiveEncoding)) continue;
                utf8 = true;
                break;
            }
        }
        return utf8 ? ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NEVER : ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS;
    }

    protected final void addResources(ResourceIterator resources, ConcurrentJarCreator zOut) throws IOException, ArchiverException {
        while (resources.hasNext()) {
            ArchiveEntry entry2 = resources.next();
            String name = entry2.getName();
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (entry2.getResource().isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(entry2, null, name, zOut);
            if (entry2.getResource().isFile()) {
                this.zipFile(entry2, zOut, name);
                continue;
            }
            this.zipDir(entry2.getResource(), zOut, name, entry2.getMode(), this.encoding);
        }
    }

    private void addParentDirs(ArchiveEntry archiveEntry, File baseDir, String entry2, ConcurrentJarCreator zOut) throws IOException {
        if (!this.doFilesonly && this.getIncludeEmptyDirs()) {
            Stack<String> directories2 = this.addedDirs.asStringStack(entry2);
            while (!directories2.isEmpty()) {
                String dir = directories2.pop();
                File f2 = baseDir != null ? new File(baseDir, dir) : new File(dir);
                AnonymousResource res = new AnonymousResource(f2);
                this.zipDir(res, zOut, dir, archiveEntry.getDefaultDirMode(), this.encoding);
            }
        }
    }

    protected void zipFile(InputStreamSupplier in, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        this.getLogger().debug("adding entry " + vPath);
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            this.setTime(ze, lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            ze.setUnixMode(0x8000 | mode);
            if (ze.isUnixSymlink()) {
                byte[] bytes2 = this.encodeArchiveEntry(symlinkDestination, this.getEncoding());
                ByteArrayInputStream payload = new ByteArrayInputStream(bytes2);
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(payload), true);
            } else {
                zOut.addArchiveEntry(ze, in, addInParallel);
            }
        }
    }

    protected void zipFile(final ArchiveEntry entry2, ConcurrentJarCreator zOut, String vPath) throws IOException, ArchiverException {
        PlexusIoResource resource = entry2.getResource();
        if (ResourceUtils.isSame(resource, this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        boolean b = entry2.getResource() instanceof SymlinkDestinationSupplier;
        String symlinkTarget = b ? ((SymlinkDestinationSupplier)((Object)entry2.getResource())).getSymlinkDestination() : null;
        InputStreamSupplier in = new InputStreamSupplier(){

            @Override
            public InputStream get() {
                try {
                    return entry2.getInputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            this.zipFile(in, zOut, vPath, resource.getLastModified(), null, entry2.getMode(), symlinkTarget, !entry2.shouldAddSynchronously());
        }
        catch (IOException e) {
            throw new ArchiverException("IOException when zipping r" + entry2.getName() + ": " + e.getMessage(), e);
        }
    }

    private void setTime(ZipEntry zipEntry2, long lastModified) {
        zipEntry2.setTime(lastModified + 1999L);
    }

    protected void zipDir(PlexusIoResource dir, ConcurrentJarCreator zOut, String vPath, int mode, String encodingToUse) throws IOException {
        if (this.addedDirs.update(vPath)) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        if (!this.skipWriting) {
            boolean isSymlink = dir instanceof SymlinkDestinationSupplier;
            if (isSymlink && vPath.endsWith(File.separator)) {
                vPath = vPath.substring(0, vPath.length() - 1);
            }
            ZipArchiveEntry ze = new ZipArchiveEntry(vPath);
            if (isSymlink) {
                mode = 0xA000 | mode;
            }
            if (dir != null && dir.isExisting()) {
                this.setTime(ze, dir.getLastModified());
            } else {
                this.setTime(ze, System.currentTimeMillis());
            }
            if (!isSymlink) {
                ze.setSize(0L);
                ze.setMethod(0);
                ze.setCrc(EMPTY_CRC);
            }
            ze.setUnixMode(mode);
            if (!isSymlink) {
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream("".getBytes())), true);
            } else {
                String symlinkDestination = ((SymlinkDestinationSupplier)((Object)dir)).getSymlinkDestination();
                byte[] bytes2 = this.encodeArchiveEntry(symlinkDestination, encodingToUse);
                ze.setMethod(8);
                zOut.addArchiveEntry(ze, this.createInputStreamSupplier(new ByteArrayInputStream(bytes2)), true);
            }
        }
    }

    private byte[] encodeArchiveEntry(String payload, String encoding) throws IOException {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding(encoding);
        ByteBuffer encodedPayloadByteBuffer = enc.encode(payload);
        byte[] encodedPayloadBytes = new byte[encodedPayloadByteBuffer.limit()];
        encodedPayloadByteBuffer.get(encodedPayloadBytes);
        return encodedPayloadBytes;
    }

    protected InputStreamSupplier createInputStreamSupplier(final InputStream inputStream) {
        return new InputStreamSupplier(){

            @Override
            public InputStream get() {
                return inputStream;
            }
        };
    }

    protected boolean createEmptyZip(File zipFile2) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile2);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile2);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
            ((OutputStream)os).close();
            os = null;
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
            }
            catch (Throwable throwable2) {
                IOUtil.close(os);
                throw throwable2;
            }
        }
        IOUtil.close(os);
        return true;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.addedDirs.clear();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        this.success = false;
        this.zOut = null;
        this.renamedFile = null;
        this.zipFile = null;
    }

    public void reset() {
        this.setDestFile(null);
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected void initZipOutputStream(ConcurrentJarCreator zOut) throws ArchiverException, IOException {
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected boolean revert(StringBuffer messageBuffer) {
        int initLength = messageBuffer.length();
        if (!(this.doUpdate && this.renamedFile == null || this.zipFile.delete())) {
            messageBuffer.append(" (and the archive is probably corrupt but I could not delete it)");
        }
        if (this.doUpdate && this.renamedFile != null) {
            try {
                FileUtils.rename(this.renamedFile, this.zipFile);
            }
            catch (IOException e) {
                messageBuffer.append(" (and I couldn't rename the temporary file ");
                messageBuffer.append(this.renamedFile.getName());
                messageBuffer.append(" back)");
            }
        }
        return messageBuffer.length() == initLength;
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.zipArchiveOutputStream != null) {
                if (this.zOut != null) {
                    this.zOut.writeTo(this.zipArchiveOutputStream);
                }
                this.zipArchiveOutputStream.close();
            }
        }
        catch (IOException ex) {
            if (this.success) {
                throw ex;
            }
        }
        catch (InterruptedException e) {
            IOException ex = new IOException("InterruptedException exception");
            ex.initCause(e.getCause());
            throw ex;
        }
        catch (ExecutionException e) {
            IOException ex = new IOException("Execution exception");
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    @Override
    protected String getArchiveType() {
        return this.archiveType;
    }
}

