/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;

public class TarResource
extends AbstractPlexusIoResource
implements ResourceAttributeSupplier {
    private final TarFile tarFile;
    private final TarArchiveEntry entry;
    private PlexusIoResourceAttributes attributes;

    public TarResource(TarFile tarFile, TarArchiveEntry entry2) {
        super(entry2.getName(), TarResource.getLastModifiedTime(entry2), entry2.isDirectory() ? -1L : entry2.getSize(), !entry2.isDirectory(), entry2.isDirectory(), true);
        this.tarFile = tarFile;
        this.entry = entry2;
    }

    private static long getLastModifiedTime(TarArchiveEntry entry2) {
        long l = entry2.getModTime().getTime();
        return l == -1L ? 0L : l;
    }

    @Override
    public synchronized PlexusIoResourceAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SimpleResourceAttributes(this.entry.getUserId(), this.entry.getUserName(), this.entry.getGroupId(), this.entry.getGroupName(), this.entry.getMode());
        }
        return this.attributes;
    }

    public synchronized void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public URL getURL() throws IOException {
        return null;
    }

    @Override
    @Nonnull
    public InputStream getContents() throws IOException {
        return this.tarFile.getInputStream(this.entry);
    }
}

