/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.ModularJarArchiver;
import org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;

public class JarToolModularJarArchiver
extends ModularJarArchiver {
    private static final String MODULE_DESCRIPTOR_FILE_NAME = "module-info.class";
    private static final Pattern MRJAR_VERSION_AREA = Pattern.compile("META-INF/versions/\\d+/");
    private Object jarTool;
    private boolean moduleDescriptorFound;

    public JarToolModularJarArchiver() {
        try {
            Class<?> toolProviderClass = Class.forName("java.util.spi.ToolProvider");
            Object jarToolOptional = toolProviderClass.getMethod("findFirst", String.class).invoke(null, "jar");
            this.jarTool = jarToolOptional.getClass().getMethod("get", new Class[0]).invoke(jarToolOptional, new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    protected void zipFile(InputStreamSupplier is, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        if (this.jarTool != null && this.isModuleDescriptor(vPath)) {
            this.getLogger().debug("Module descriptor found: " + vPath);
            this.moduleDescriptorFound = true;
        }
        super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode, symlinkDestination, addInParallel);
    }

    @Override
    protected void postCreateArchive() throws ArchiverException {
        if (!this.moduleDescriptorFound) {
            return;
        }
        try {
            this.getLogger().debug("Using the jar tool to update the archive to modular JAR.");
            Integer result2 = (Integer)this.jarTool.getClass().getMethod("run", PrintStream.class, PrintStream.class, String[].class).invoke(this.jarTool, System.out, System.err, this.getJarToolArguments());
            if (result2 != null && result2 != 0) {
                throw new ArchiverException("Could not create modular JAR file. The JDK jar tool exited with " + result2);
            }
        }
        catch (IOException | ReflectiveOperationException | SecurityException e) {
            throw new ArchiverException("Exception occurred while creating modular JAR file", e);
        }
    }

    private boolean isModuleDescriptor(String path2) {
        if (path2.endsWith(MODULE_DESCRIPTOR_FILE_NAME)) {
            String prefix = path2.substring(0, path2.lastIndexOf(MODULE_DESCRIPTOR_FILE_NAME));
            return prefix.isEmpty() || MRJAR_VERSION_AREA.matcher(prefix).matches();
        }
        return false;
    }

    private String[] getJarToolArguments() throws IOException {
        String mainClass2;
        File tempEmptyDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        tempEmptyDir.deleteOnExit();
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("--update");
        args2.add("--file");
        args2.add(this.getDestFile().getAbsolutePath());
        String string2 = mainClass2 = this.getModuleMainClass() != null ? this.getModuleMainClass() : this.getManifestMainClass();
        if (mainClass2 != null) {
            args2.add("--main-class");
            args2.add(mainClass2);
        }
        if (this.getModuleVersion() != null) {
            args2.add("--module-version");
            args2.add(this.getModuleVersion());
        }
        if (!this.isCompress()) {
            args2.add("--no-compress");
        }
        args2.add("-C");
        args2.add(tempEmptyDir.getAbsolutePath());
        args2.add(".");
        return args2.toArray(new String[0]);
    }
}

