/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JdkManifestFactory;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;

public class JarArchiver
extends ZipArchiver {
    private static final String META_INF_NAME = "META-INF";
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector<String> rootEntries;
    private ArrayList<String> indexJars;

    public JarArchiver() {
        this.archiveType = "jar";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    @Deprecated
    public void setManifestEncoding(String manifestEncoding) {
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            JdkManifestFactory.merge(this.configuredManifest, newManifest, false);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) throws ArchiverException {
        if (!manifestFile.exists()) {
            throw new ArchiverException("Manifest file: " + manifestFile + " does not exist.");
        }
        this.manifestFile = manifestFile;
    }

    private Manifest getManifest(File manifestFile) throws ArchiverException {
        Manifest manifest2;
        FileInputStream in = null;
        try {
            in = new FileInputStream(manifestFile);
            Manifest mf = this.getManifest(in);
            ((InputStream)in).close();
            in = null;
            manifest2 = mf;
        }
        catch (IOException e) {
            try {
                throw new ArchiverException("Unable to read manifest file: " + manifestFile + " (" + e.getMessage() + ")", e);
            }
            catch (Throwable throwable2) {
                IOUtil.close(in);
                throw throwable2;
            }
        }
        IOUtil.close(in);
        return manifest2;
    }

    private Manifest getManifest(InputStream is) throws ArchiverException {
        try {
            return new Manifest(is);
        }
        catch (IOException e) {
            throw new ArchiverException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        boolean bl = this.mergeManifestsMain = FilesetManifestConfig.merge == config;
        if (this.filesetManifestConfig != null && this.filesetManifestConfig != FilesetManifestConfig.skip) {
            this.doubleFilePass = true;
        }
    }

    public void addConfiguredIndexJars(File indexJar) {
        if (this.indexJars == null) {
            this.indexJars = new ArrayList();
        }
        this.indexJars.add(indexJar.getAbsolutePath());
    }

    @Override
    protected void initZipOutputStream(ConcurrentJarCreator zOut) throws ArchiverException, IOException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    @Override
    protected boolean hasVirtualFiles() {
        this.getLogger().debug("\n\n\nChecking for jar manifest virtual files...\n\n\n");
        System.out.flush();
        return this.configuredManifest != null || this.manifest != null || this.manifestFile != null || super.hasVirtualFiles();
    }

    protected Manifest createManifest() throws ArchiverException {
        Manifest finalManifest = Manifest.getDefaultManifest();
        if (this.manifest == null && this.manifestFile != null) {
            this.manifest = this.getManifest(this.manifestFile);
        }
        if (this.isInUpdateMode()) {
            JdkManifestFactory.merge(finalManifest, this.originalManifest, false);
        }
        JdkManifestFactory.merge(finalManifest, this.filesetManifest, false);
        JdkManifestFactory.merge(finalManifest, this.configuredManifest, false);
        JdkManifestFactory.merge(finalManifest, this.manifest, !this.mergeManifestsMain);
        return finalManifest;
    }

    private void writeManifest(ConcurrentJarCreator zOut, Manifest manifest2) throws IOException, ArchiverException {
        Enumeration<String> e = manifest2.getWarnings();
        while (e.hasMoreElements()) {
            this.getLogger().warn("Manifest warning: " + e.nextElement());
        }
        this.zipDir(null, zOut, "META-INF/", 16877, this.getEncoding());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        manifest2.write(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(this.createInputStreamSupplier(bais), zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188, null, false);
        super.initZipOutputStream(zOut);
    }

    @Override
    protected void finalizeZipOutputStream(ConcurrentJarCreator zOut) throws IOException, ArchiverException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ConcurrentJarCreator zOut) throws IOException, ArchiverException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.getDestFile().getName());
        Set<String> filteredDirs = this.addedDirs.allAddedDirs();
        if (filteredDirs.contains("META-INF/")) {
            boolean add2 = false;
            for (String entry2 : this.entries.keySet()) {
                if (!entry2.startsWith("META-INF/") || entry2.equals(INDEX_NAME) || entry2.equals(MANIFEST_NAME)) continue;
                add2 = true;
                break;
            }
            if (!add2) {
                filteredDirs.remove("META-INF/");
            }
        }
        this.writeIndexLikeList(new ArrayList<String>(filteredDirs), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            String classpath = mf.getMainAttributes().getValue("Class-Path");
            String[] cpEntries = null;
            if (classpath != null) {
                StringTokenizer tok = new StringTokenizer(classpath, " ");
                cpEntries = new String[tok.countTokens()];
                int c = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c++] = tok.nextToken();
                }
            }
            for (String indexJar : this.indexJars) {
                String name = JarArchiver.findJarName(indexJar, cpEntries);
                if (name == null) continue;
                ArrayList<String> dirs2 = new ArrayList<String>();
                ArrayList<String> files2 = new ArrayList<String>();
                JarArchiver.grabFilesAndDirs(indexJar, dirs2, files2);
                if (dirs2.size() + files2.size() <= 0) continue;
                writer.println(name);
                this.writeIndexLikeList(dirs2, files2, writer);
                writer.println();
            }
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(this.createInputStreamSupplier(bais), zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188, null, true);
    }

    @Override
    protected void zipFile(InputStreamSupplier is, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.skipWriting) {
                try (InputStream manifestInputStream = is.get();){
                    this.filesetManifest(fromArchive, manifestInputStream);
                }
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.getLogger().warn("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will be replaced by a newly generated one.");
        } else {
            if (this.index && !vPath.contains("/")) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode, symlinkDestination, addInParallel);
        }
    }

    private void filesetManifest(File file, InputStream is) throws ArchiverException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.getLogger().debug("Found manifest " + file);
            this.manifest = is != null ? this.getManifest(is) : this.getManifest(file);
        } else if (this.filesetManifestConfig != null && this.filesetManifestConfig != FilesetManifestConfig.skip) {
            this.getLogger().debug("Found manifest to merge in file " + file);
            Manifest newManifest = is != null ? this.getManifest(is) : this.getManifest(file);
            if (this.filesetManifest == null) {
                this.filesetManifest = newManifest;
            } else {
                JdkManifestFactory.merge(this.filesetManifest, newManifest, false);
            }
        }
    }

    @Override
    protected boolean createEmptyZip(File zipFile2) throws ArchiverException {
        if (!this.createEmpty) {
            return true;
        }
        try {
            this.getLogger().debug("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            this.zipArchiveOutputStream = new ZipArchiveOutputStream(Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile(), "jar")));
            this.zipArchiveOutputStream.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                this.zipArchiveOutputStream.setMethod(8);
            } else {
                this.zipArchiveOutputStream.setMethod(0);
            }
            ConcurrentJarCreator ps = new ConcurrentJarCreator(this.isRecompressAddedZips(), Runtime.getRuntime().availableProcessors());
            this.initZipOutputStream(ps);
            this.finalizeZipOutputStream(ps);
        }
        catch (IOException ioe) {
            throw new ArchiverException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe);
        }
        finally {
            this.createEmpty = false;
        }
        return true;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    @Override
    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List<String> dirs2, List<String> files2, PrintWriter writer) {
        Collections.sort(dirs2);
        Collections.sort(files2);
        for (String dir : dirs2) {
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos2 = dir.lastIndexOf(47);
            if (pos2 != -1) {
                dir = dir.substring(0, pos2);
            }
            writer.println(dir);
        }
        for (String file : files2) {
            writer.println(file);
        }
    }

    protected static String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<String, String> matches2 = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 != null && o2 != null) {
                    return o2.length() - o1.length();
                }
                return 0;
            }
        });
        block0: for (String aClasspath : classpath) {
            if (fileName.endsWith(aClasspath)) {
                matches2.put(aClasspath, aClasspath);
                continue;
            }
            int slash = aClasspath.indexOf("/");
            String candidate = aClasspath;
            while (slash > -1) {
                if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                    matches2.put(candidate, aClasspath);
                    continue block0;
                }
                slash = candidate.indexOf("/");
            }
        }
        return matches2.size() == 0 ? null : (String)matches2.get(matches2.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void grabFilesAndDirs(String file, List<String> dirs2, List<String> files2) throws IOException {
        File zipFile2 = new File(file);
        if (!zipFile2.exists()) {
            ConsoleLogger logger = new ConsoleLogger(1, "console");
            logger.error("JarArchive skipping non-existing file: " + zipFile2.getAbsolutePath());
        } else if (zipFile2.isDirectory()) {
            ConsoleLogger logger = new ConsoleLogger(1, "console");
            logger.info("JarArchiver skipping indexJar " + zipFile2 + " because it is not a jar");
        } else {
            try (ZipFile zf = null;){
                zf = new ZipFile(file, "utf-8");
                Enumeration<ZipArchiveEntry> entries2 = zf.getEntries();
                HashSet<String> dirSet = new HashSet<String>();
                while (entries2.hasMoreElements()) {
                    ZipArchiveEntry ze = entries2.nextElement();
                    String name = ze.getName();
                    if (name.equals(META_INF_NAME) || name.equals("META-INF/") || name.equals(INDEX_NAME) || name.equals(MANIFEST_NAME)) continue;
                    if (ze.isDirectory()) {
                        dirSet.add(name);
                        continue;
                    }
                    if (!name.contains("/")) {
                        files2.add(name);
                        continue;
                    }
                    dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
                }
                dirs2.addAll(dirSet);
            }
        }
    }

    public static enum FilesetManifestConfig {
        skip,
        merge,
        mergewithoutmain;

    }
}

