/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.codehaus.classworlds.DefaultClassRealm;
import org.codehaus.classworlds.RealmClassLoader;

public class UberJarRealmClassLoader
extends RealmClassLoader {
    private Map classIndex;
    private List urls = new ArrayList();
    private Map jarIndexes;

    public UberJarRealmClassLoader(DefaultClassRealm realm) {
        super(realm);
        this.classIndex = new HashMap();
        this.jarIndexes = new HashMap();
    }

    public void addConstituent(URL constituent) {
        if ("jar".equals(constituent.getProtocol()) || constituent.toExternalForm().endsWith(".jar")) {
            this.buildIndexForJar(constituent);
        }
        this.urls.add(constituent);
        super.addConstituent(constituent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndexForJar(URL inUrl) {
        HashMap<String, URL> index = new HashMap<String, URL>();
        String urlText = null;
        urlText = inUrl.getProtocol().equals("jar") ? inUrl.toExternalForm() : "jar:" + inUrl.toExternalForm();
        URL resourceUrl = null;
        try {
            JarInputStream in = new JarInputStream(inUrl.openStream());
            try {
                JarEntry entry2 = null;
                while ((entry2 = in.getNextJarEntry()) != null) {
                    String resourceName = entry2.getName();
                    resourceUrl = new URL(urlText + "!/" + resourceName);
                    index.put(resourceName, resourceUrl);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.jarIndexes.put(inUrl, index);
    }

    public Class loadClassDirect(String className) throws ClassNotFoundException {
        String classPath2 = className.replace('.', '/') + ".class";
        if (this.classIndex.containsKey(classPath2)) {
            return (Class)this.classIndex.get(classPath2);
        }
        Iterator urlIter = this.urls.iterator();
        URL eachUrl = null;
        byte[] classBytes2 = null;
        while (classBytes2 == null && urlIter.hasNext()) {
            eachUrl = (URL)urlIter.next();
            if ("jar".equals(eachUrl.getProtocol()) || eachUrl.toExternalForm().endsWith(".jar")) {
                classBytes2 = this.findClassInJarStream(eachUrl, classPath2);
                continue;
            }
            classBytes2 = this.findClassInDirectoryUrl(eachUrl, classPath2);
        }
        if (classBytes2 == null) {
            return null;
        }
        Class<?> cls = this.defineClass(className, classBytes2, 0, classBytes2.length);
        this.classIndex.put(classPath2, cls);
        return cls;
    }

    public URL findResource(String name) {
        URL resourceUrl = null;
        Iterator urlIter = this.urls.iterator();
        URL eachUrl = null;
        while (urlIter.hasNext()) {
            eachUrl = (URL)urlIter.next();
            resourceUrl = "jar".equals(eachUrl.getProtocol()) || eachUrl.toExternalForm().endsWith(".jar") ? this.findResourceInJarStream(eachUrl, name) : this.findResourceInDirectoryUrl(eachUrl, name);
            if (resourceUrl == null) continue;
            return resourceUrl;
        }
        return null;
    }

    public Enumeration findResourcesDirect(String name) {
        Vector<URL> list2 = new Vector<URL>();
        URL resourceUrl = null;
        Iterator urlIter = this.urls.iterator();
        URL eachUrl = null;
        while (urlIter.hasNext()) {
            eachUrl = (URL)urlIter.next();
            resourceUrl = "jar".equals(eachUrl.getProtocol()) || eachUrl.toExternalForm().endsWith(".jar") ? this.findResourceInJarStream(eachUrl, name) : this.findResourceInDirectoryUrl(eachUrl, name);
            if (resourceUrl == null) continue;
            list2.add(resourceUrl);
        }
        return list2.elements();
    }

    protected URL findResourceInJarStream(URL inUrl, String path2) {
        return (URL)((Map)this.jarIndexes.get(inUrl)).get(path2);
    }

    protected URL findResourceInDirectoryUrl(URL inUrl, String path2) {
        return null;
    }

    protected byte[] findClassInJarStream(URL inUrl, String path2) {
        URL classUrl = (URL)((Map)this.jarIndexes.get(inUrl)).get(path2);
        if (classUrl != null) {
            try {
                return this.readStream(classUrl.openStream());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected byte[] findClassInDirectoryUrl(URL url, String path2) {
        try {
            URL classUrl = new URL(url, path2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[2048];
            int read2 = 0;
            while (in.available() > 0 && (read2 = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, read2);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            out.close();
        }
    }
}

