/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.yarn;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import java.util.Map;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;

class YarnShuffleServiceMetrics
implements MetricsSource {
    private final MetricSet metricSet;

    YarnShuffleServiceMetrics(MetricSet metricSet) {
        this.metricSet = metricSet;
    }

    public void getMetrics(MetricsCollector collector, boolean all2) {
        MetricsRecordBuilder metricsRecordBuilder = collector.addRecord("sparkShuffleService");
        for (Map.Entry<String, Metric> entry2 : this.metricSet.getMetrics().entrySet()) {
            YarnShuffleServiceMetrics.collectMetric(metricsRecordBuilder, entry2.getKey(), entry2.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void collectMetric(MetricsRecordBuilder metricsRecordBuilder, String name, Metric metric) {
        if (metric instanceof Timer) {
            Timer t = (Timer)metric;
            metricsRecordBuilder.addCounter((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_count", "Count of timer " + name), t.getCount()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate15", "15 minute rate of timer " + name), t.getFifteenMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate5", "5 minute rate of timer " + name), t.getFiveMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate1", "1 minute rate of timer " + name), t.getOneMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rateMean", "Mean rate of timer " + name), t.getMeanRate());
            return;
        } else if (metric instanceof Meter) {
            Meter m = (Meter)metric;
            metricsRecordBuilder.addCounter((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_count", "Count of meter " + name), m.getCount()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate15", "15 minute rate of meter " + name), m.getFifteenMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate5", "5 minute rate of meter " + name), m.getFiveMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rate1", "1 minute rate of meter " + name), m.getOneMinuteRate()).addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name + "_rateMean", "Mean rate of meter " + name), m.getMeanRate());
            return;
        } else if (metric instanceof Gauge) {
            Object gaugeValue = ((Gauge)metric).getValue();
            if (gaugeValue instanceof Integer) {
                metricsRecordBuilder.addGauge(YarnShuffleServiceMetrics.getShuffleServiceMetricsInfo(name), ((Integer)gaugeValue).intValue());
                return;
            } else if (gaugeValue instanceof Long) {
                metricsRecordBuilder.addGauge(YarnShuffleServiceMetrics.getShuffleServiceMetricsInfo(name), ((Long)gaugeValue).longValue());
                return;
            } else if (gaugeValue instanceof Float) {
                metricsRecordBuilder.addGauge(YarnShuffleServiceMetrics.getShuffleServiceMetricsInfo(name), ((Float)gaugeValue).floatValue());
                return;
            } else {
                if (!(gaugeValue instanceof Double)) throw new IllegalStateException("Not supported class type of metric[" + name + "] for value " + gaugeValue);
                metricsRecordBuilder.addGauge(YarnShuffleServiceMetrics.getShuffleServiceMetricsInfo(name), ((Double)gaugeValue).doubleValue());
            }
            return;
        } else {
            if (!(metric instanceof Counter)) return;
            Counter c = (Counter)metric;
            long counterValue = c.getCount();
            metricsRecordBuilder.addGauge((MetricsInfo)new ShuffleServiceMetricsInfo(name, "Number of connections to shuffle service " + name), counterValue);
        }
    }

    private static MetricsInfo getShuffleServiceMetricsInfo(String name) {
        return new ShuffleServiceMetricsInfo(name, "Value of gauge " + name);
    }

    private static class ShuffleServiceMetricsInfo
    implements MetricsInfo {
        private final String name;
        private final String description;

        ShuffleServiceMetricsInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }
    }
}

