/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.spark.network.util.TransportConf;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.io.netty.buffer.PoolArenaMetric;
import org.spark_project.io.netty.buffer.PooledByteBufAllocator;
import org.spark_project.io.netty.buffer.PooledByteBufAllocatorMetric;

public class NettyMemoryMetrics
implements MetricSet {
    private final PooledByteBufAllocator pooledAllocator;
    private final boolean verboseMetricsEnabled;
    private final Map<String, Metric> allMetrics;
    private final String metricPrefix;
    @VisibleForTesting
    static final Set<String> VERBOSE_METRICS = new HashSet<String>();

    public NettyMemoryMetrics(PooledByteBufAllocator pooledAllocator, String metricPrefix, TransportConf conf) {
        this.pooledAllocator = pooledAllocator;
        this.allMetrics = new HashMap<String, Metric>();
        this.metricPrefix = metricPrefix;
        this.verboseMetricsEnabled = conf.verboseMetrics();
        this.registerMetrics(this.pooledAllocator);
    }

    private void registerMetrics(PooledByteBufAllocator allocator) {
        PooledByteBufAllocatorMetric pooledAllocatorMetric = allocator.metric();
        this.allMetrics.put(MetricRegistry.name(this.metricPrefix, "usedHeapMemory"), () -> pooledAllocatorMetric.usedHeapMemory());
        this.allMetrics.put(MetricRegistry.name(this.metricPrefix, "usedDirectMemory"), () -> pooledAllocatorMetric.usedDirectMemory());
        if (this.verboseMetricsEnabled) {
            int directArenaIndex = 0;
            for (PoolArenaMetric metric : pooledAllocatorMetric.directArenas()) {
                this.registerArenaMetric(metric, "directArena" + directArenaIndex);
                ++directArenaIndex;
            }
            int heapArenaIndex = 0;
            for (PoolArenaMetric metric : pooledAllocatorMetric.heapArenas()) {
                this.registerArenaMetric(metric, "heapArena" + heapArenaIndex);
                ++heapArenaIndex;
            }
        }
    }

    private void registerArenaMetric(PoolArenaMetric arenaMetric, String arenaName) {
        for (String methodName : VERBOSE_METRICS) {
            Method m;
            try {
                m = PoolArenaMetric.class.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?> returnType = m.getReturnType();
            String metricName = MetricRegistry.name(this.metricPrefix, arenaName, m.getName());
            if (returnType.equals(Integer.TYPE)) {
                this.allMetrics.put(metricName, () -> {
                    try {
                        return (Integer)m.invoke((Object)arenaMetric, new Object[0]);
                    }
                    catch (Exception e) {
                        return -1;
                    }
                });
                continue;
            }
            if (!returnType.equals(Long.TYPE)) continue;
            this.allMetrics.put(metricName, () -> {
                try {
                    return (Long)m.invoke((Object)arenaMetric, new Object[0]);
                }
                catch (Exception e) {
                    return -1L;
                }
            });
        }
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.allMetrics);
    }

    static {
        VERBOSE_METRICS.addAll(Arrays.asList("numAllocations", "numTinyAllocations", "numSmallAllocations", "numNormalAllocations", "numHugeAllocations", "numDeallocations", "numTinyDeallocations", "numSmallDeallocations", "numNormalDeallocations", "numHugeDeallocations", "numActiveAllocations", "numActiveTinyAllocations", "numActiveSmallAllocations", "numActiveNormalAllocations", "numActiveHugeAllocations", "numActiveBytes"));
    }
}

