/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.spark.network.util.ConfigProvider;

public class MapConfigProvider
extends ConfigProvider {
    public static final MapConfigProvider EMPTY = new MapConfigProvider(Collections.emptyMap());
    private final Map<String, String> config;

    public MapConfigProvider(Map<String, String> config) {
        this.config = new HashMap<String, String>(config);
    }

    @Override
    public String get(String name) {
        String value2 = this.config.get(name);
        if (value2 == null) {
            throw new NoSuchElementException(name);
        }
        return value2;
    }

    @Override
    public String get(String name, String defaultValue2) {
        String value2 = this.config.get(name);
        return value2 == null ? defaultValue2 : value2;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getAll() {
        return this.config.entrySet();
    }
}

