/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.com.fasterxml.jackson.annotation.JsonCreator;
import org.spark_project.com.fasterxml.jackson.annotation.JsonProperty;
import org.spark_project.com.fasterxml.jackson.databind.ObjectMapper;

public class LevelDBProvider {
    private static final Logger logger = LoggerFactory.getLogger(LevelDBProvider.class);

    public static DB initLevelDB(File dbFile, StoreVersion version, ObjectMapper mapper2) throws IOException {
        DB tmpDb = null;
        if (dbFile != null) {
            Options options2 = new Options();
            options2.createIfMissing(false);
            options2.logger(new LevelDBLogger());
            try {
                tmpDb = JniDBFactory.factory.open(dbFile, options2);
            }
            catch (NativeDB.DBException e) {
                if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                    logger.info("Creating state database at " + dbFile);
                    options2.createIfMissing(true);
                    try {
                        tmpDb = JniDBFactory.factory.open(dbFile, options2);
                    }
                    catch (NativeDB.DBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening leveldb file {}.  Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f2 : dbFile.listFiles()) {
                        if (f2.delete()) continue;
                        logger.warn("error deleting {}", (Object)f2.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", (Object)dbFile.getPath());
                }
                options2.createIfMissing(true);
                try {
                    tmpDb = JniDBFactory.factory.open(dbFile, options2);
                }
                catch (NativeDB.DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            LevelDBProvider.checkVersion(tmpDb, version, mapper2);
        }
        return tmpDb;
    }

    public static void checkVersion(DB db, StoreVersion newversion, ObjectMapper mapper2) throws IOException {
        byte[] bytes2 = db.get(StoreVersion.KEY);
        if (bytes2 == null) {
            LevelDBProvider.storeVersion(db, newversion, mapper2);
        } else {
            StoreVersion version = mapper2.readValue(bytes2, StoreVersion.class);
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + version + ", incompatible with current version " + newversion);
            }
            LevelDBProvider.storeVersion(db, newversion, mapper2);
        }
    }

    public static void storeVersion(DB db, StoreVersion version, ObjectMapper mapper2) throws IOException {
        db.put(StoreVersion.KEY, mapper2.writeValueAsBytes(version));
    }

    public static class StoreVersion {
        static final byte[] KEY = "StoreVersion".getBytes(StandardCharsets.UTF_8);
        public final int major;
        public final int minor;

        @JsonCreator
        public StoreVersion(@JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor) {
            this.major = major;
            this.minor = minor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoreVersion that = (StoreVersion)o;
            return this.major == that.major && this.minor == that.minor;
        }

        public int hashCode() {
            int result2 = this.major;
            result2 = 31 * result2 + this.minor;
            return result2;
        }
    }

    private static class LevelDBLogger
    implements org.iq80.leveldb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        @Override
        public void log(String message) {
            LOG.info(message);
        }
    }
}

