/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.spark_project.io.netty.buffer.ByteBuf;

public class ByteArrayReadableChannel
implements ReadableByteChannel {
    private ByteBuf data;

    public int readableBytes() {
        return this.data.readableBytes();
    }

    public void feedData(ByteBuf buf) {
        this.data = buf;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int totalRead = 0;
        while (this.data.readableBytes() > 0 && dst.remaining() > 0) {
            int bytesToRead = Math.min(this.data.readableBytes(), dst.remaining());
            dst.put(this.data.readSlice(bytesToRead).nioBuffer());
            totalRead += bytesToRead;
        }
        if (this.data.readableBytes() == 0) {
            this.data.release();
        }
        return totalRead;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }
}

