/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol.mesos;

import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public class RegisterDriver
extends BlockTransferMessage {
    private final String appId;
    private final long heartbeatTimeoutMs;

    public RegisterDriver(String appId, long heartbeatTimeoutMs) {
        this.appId = appId;
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
    }

    public String getAppId() {
        return this.appId;
    }

    public long getHeartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REGISTER_DRIVER;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.appId) + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.appId);
        buf.writeLong(this.heartbeatTimeoutMs);
    }

    public int hashCode() {
        return Objects.hashCode(this.appId, this.heartbeatTimeoutMs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RegisterDriver)) {
            return false;
        }
        return Objects.equal(this.appId, ((RegisterDriver)o).appId);
    }

    public static RegisterDriver decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode(buf);
        long heartbeatTimeout = buf.readLong();
        return new RegisterDriver(appId, heartbeatTimeout);
    }
}

