/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public class UploadBlockStream
extends BlockTransferMessage {
    public final String blockId;
    public final byte[] metadata;

    public UploadBlockStream(String blockId, byte[] metadata) {
        this.blockId = blockId;
        this.metadata = metadata;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.UPLOAD_BLOCK_STREAM;
    }

    public int hashCode() {
        int objectsHashCode = Objects.hashCode(this.blockId);
        return objectsHashCode * 41 + Arrays.hashCode(this.metadata);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("blockId", this.blockId).add("metadata size", this.metadata.length).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof UploadBlockStream) {
            UploadBlockStream o = (UploadBlockStream)other;
            return Objects.equal(this.blockId, o.blockId) && Arrays.equals(this.metadata, o.metadata);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.blockId) + Encoders.ByteArrays.encodedLength(this.metadata);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.blockId);
        Encoders.ByteArrays.encode(buf, this.metadata);
    }

    public static UploadBlockStream decode(ByteBuf buf) {
        String blockId = Encoders.Strings.decode(buf);
        byte[] metadata = Encoders.ByteArrays.decode(buf);
        return new UploadBlockStream(blockId, metadata);
    }
}

