/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public class RegisterExecutor
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final ExecutorShuffleInfo executorInfo;

    public RegisterExecutor(String appId, String execId, ExecutorShuffleInfo executorInfo) {
        this.appId = appId;
        this.execId = execId;
        this.executorInfo = executorInfo;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REGISTER_EXECUTOR;
    }

    public int hashCode() {
        return Objects.hashCode(this.appId, this.execId, this.executorInfo);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("appId", this.appId).add("execId", this.execId).add("executorInfo", this.executorInfo).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof RegisterExecutor) {
            RegisterExecutor o = (RegisterExecutor)other;
            return Objects.equal(this.appId, o.appId) && Objects.equal(this.execId, o.execId) && Objects.equal(this.executorInfo, o.executorInfo);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.appId) + Encoders.Strings.encodedLength(this.execId) + this.executorInfo.encodedLength();
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.appId);
        Encoders.Strings.encode(buf, this.execId);
        this.executorInfo.encode(buf);
    }

    public static RegisterExecutor decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode(buf);
        String execId = Encoders.Strings.decode(buf);
        ExecutorShuffleInfo executorShuffleInfo = ExecutorShuffleInfo.decode(buf);
        return new RegisterExecutor(appId, execId, executorShuffleInfo);
    }
}

