/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public class OpenBlocks
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final String[] blockIds;

    public OpenBlocks(String appId, String execId, String[] blockIds) {
        this.appId = appId;
        this.execId = execId;
        this.blockIds = blockIds;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.OPEN_BLOCKS;
    }

    public int hashCode() {
        return Objects.hashCode(this.appId, this.execId) * 41 + Arrays.hashCode(this.blockIds);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("appId", this.appId).add("execId", this.execId).add("blockIds", Arrays.toString(this.blockIds)).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof OpenBlocks) {
            OpenBlocks o = (OpenBlocks)other;
            return Objects.equal(this.appId, o.appId) && Objects.equal(this.execId, o.execId) && Arrays.equals(this.blockIds, o.blockIds);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.appId) + Encoders.Strings.encodedLength(this.execId) + Encoders.StringArrays.encodedLength(this.blockIds);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.appId);
        Encoders.Strings.encode(buf, this.execId);
        Encoders.StringArrays.encode(buf, this.blockIds);
    }

    public static OpenBlocks decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode(buf);
        String execId = Encoders.Strings.decode(buf);
        String[] blockIds = Encoders.StringArrays.decode(buf);
        return new OpenBlocks(appId, execId, blockIds);
    }
}

