/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import java.util.Arrays;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.Encoders;
import org.spark_project.com.fasterxml.jackson.annotation.JsonCreator;
import org.spark_project.com.fasterxml.jackson.annotation.JsonProperty;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public class ExecutorShuffleInfo
implements Encodable {
    public final String[] localDirs;
    public final int subDirsPerLocalDir;
    public final String shuffleManager;

    @JsonCreator
    public ExecutorShuffleInfo(@JsonProperty(value="localDirs") String[] localDirs, @JsonProperty(value="subDirsPerLocalDir") int subDirsPerLocalDir, @JsonProperty(value="shuffleManager") String shuffleManager) {
        this.localDirs = localDirs;
        this.subDirsPerLocalDir = subDirsPerLocalDir;
        this.shuffleManager = shuffleManager;
    }

    public int hashCode() {
        return Objects.hashCode(this.subDirsPerLocalDir, this.shuffleManager) * 41 + Arrays.hashCode(this.localDirs);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("localDirs", Arrays.toString(this.localDirs)).add("subDirsPerLocalDir", this.subDirsPerLocalDir).add("shuffleManager", this.shuffleManager).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof ExecutorShuffleInfo) {
            ExecutorShuffleInfo o = (ExecutorShuffleInfo)other;
            return Arrays.equals(this.localDirs, o.localDirs) && Objects.equal(this.subDirsPerLocalDir, o.subDirsPerLocalDir) && Objects.equal(this.shuffleManager, o.shuffleManager);
        }
        return false;
    }

    @Override
    public int encodedLength() {
        return Encoders.StringArrays.encodedLength(this.localDirs) + 4 + Encoders.Strings.encodedLength(this.shuffleManager);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.StringArrays.encode(buf, this.localDirs);
        buf.writeInt(this.subDirsPerLocalDir);
        Encoders.Strings.encode(buf, this.shuffleManager);
    }

    public static ExecutorShuffleInfo decode(ByteBuf buf) {
        String[] localDirs = Encoders.StringArrays.decode(buf);
        int subDirsPerLocalDir = buf.readInt();
        String shuffleManager = Encoders.Strings.decode(buf);
        return new ExecutorShuffleInfo(localDirs, subDirsPerLocalDir, shuffleManager);
    }
}

