/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricSet;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyMemoryMetrics;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Lists;
import org.spark_project.io.netty.bootstrap.ServerBootstrap;
import org.spark_project.io.netty.buffer.PooledByteBufAllocator;
import org.spark_project.io.netty.channel.ChannelFuture;
import org.spark_project.io.netty.channel.ChannelInitializer;
import org.spark_project.io.netty.channel.ChannelOption;
import org.spark_project.io.netty.channel.EventLoopGroup;
import org.spark_project.io.netty.channel.socket.SocketChannel;

public class TransportServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportServer.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final RpcHandler appRpcHandler;
    private final List<TransportServerBootstrap> bootstraps;
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private int port = -1;
    private final PooledByteBufAllocator pooledAllocator;
    private NettyMemoryMetrics metrics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportServer(TransportContext context, String hostToBind, int portToBind, RpcHandler appRpcHandler, List<TransportServerBootstrap> bootstraps) {
        this.context = context;
        this.conf = context.getConf();
        this.appRpcHandler = appRpcHandler;
        this.pooledAllocator = this.conf.sharedByteBufAllocators() ? NettyUtils.getSharedPooledByteBufAllocator(this.conf.preferDirectBufsForSharedByteBufAllocators(), true) : NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), true, this.conf.serverThreads());
        this.bootstraps = Lists.newArrayList((Iterable)Preconditions.checkNotNull(bootstraps));
        boolean shouldClose = true;
        try {
            this.init(hostToBind, portToBind);
            shouldClose = false;
        }
        finally {
            if (shouldClose) {
                JavaUtils.closeQuietly(this);
            }
        }
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Server not initialized");
        }
        return this.port;
    }

    private void init(String hostToBind, int portToBind) {
        EventLoopGroup bossGroup;
        IOMode ioMode = IOMode.valueOf(this.conf.ioMode());
        EventLoopGroup workerGroup = bossGroup = NettyUtils.createEventLoop(ioMode, this.conf.serverThreads(), this.conf.getModuleName() + "-server");
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NettyUtils.getServerChannelClass(ioMode))).option(ChannelOption.ALLOCATOR, this.pooledAllocator)).option(ChannelOption.SO_REUSEADDR, !SystemUtils.IS_OS_WINDOWS)).childOption(ChannelOption.ALLOCATOR, this.pooledAllocator);
        this.metrics = new NettyMemoryMetrics(this.pooledAllocator, this.conf.getModuleName() + "-server", this.conf);
        if (this.conf.backLog() > 0) {
            this.bootstrap.option(ChannelOption.SO_BACKLOG, this.conf.backLog());
        }
        if (this.conf.receiveBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, this.conf.sendBuf());
        }
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                RpcHandler rpcHandler = TransportServer.this.appRpcHandler;
                for (TransportServerBootstrap bootstrap : TransportServer.this.bootstraps) {
                    rpcHandler = bootstrap.doBootstrap(ch, rpcHandler);
                }
                TransportServer.this.context.initializePipeline(ch, rpcHandler);
            }
        });
        InetSocketAddress address = hostToBind == null ? new InetSocketAddress(portToBind) : new InetSocketAddress(hostToBind, portToBind);
        this.channelFuture = this.bootstrap.bind(address);
        this.channelFuture.syncUninterruptibly();
        this.port = ((InetSocketAddress)this.channelFuture.channel().localAddress()).getPort();
        logger.debug("Shuffle server started on port: {}", (Object)this.port);
    }

    public MetricSet getAllMetrics() {
        return this.metrics;
    }

    @Override
    public void close() {
        if (this.channelFuture != null) {
            this.channelFuture.channel().close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
            this.channelFuture = null;
        }
        if (this.bootstrap != null && this.bootstrap.config().group() != null) {
            this.bootstrap.config().group().shutdownGracefully();
        }
        if (this.bootstrap != null && this.bootstrap.config().childGroup() != null) {
            this.bootstrap.config().childGroup().shutdownGracefully();
        }
        this.bootstrap = null;
    }

    public Counter getRegisteredConnections() {
        return this.context.getRegisteredConnections();
    }
}

