/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public final class UploadStream
extends AbstractMessage
implements RequestMessage {
    public final long requestId;
    public final ManagedBuffer meta;
    public final long bodyByteCount;

    public UploadStream(long requestId, ManagedBuffer meta, ManagedBuffer body2) {
        super(body2, false);
        this.requestId = requestId;
        this.meta = meta;
        this.bodyByteCount = body2.size();
    }

    private UploadStream(long requestId, ManagedBuffer meta, long bodyByteCount) {
        super(null, false);
        this.requestId = requestId;
        this.meta = meta;
        this.bodyByteCount = bodyByteCount;
    }

    @Override
    public Message.Type type() {
        return Message.Type.UploadStream;
    }

    @Override
    public int encodedLength() {
        return 12 + (int)this.meta.size() + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        try {
            ByteBuffer metaBuf = this.meta.nioByteBuffer();
            buf.writeInt(metaBuf.remaining());
            buf.writeBytes(metaBuf);
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        buf.writeLong(this.bodyByteCount);
    }

    public static UploadStream decode(ByteBuf buf) {
        long requestId = buf.readLong();
        int metaSize = buf.readInt();
        NettyManagedBuffer meta = new NettyManagedBuffer(buf.readRetainedSlice(metaSize));
        long bodyByteCount = buf.readLong();
        return new UploadStream(requestId, (ManagedBuffer)meta, bodyByteCount);
    }

    public int hashCode() {
        return Long.hashCode(this.requestId);
    }

    public boolean equals(Object other) {
        if (other instanceof UploadStream) {
            UploadStream o = (UploadStream)other;
            return this.requestId == o.requestId && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("requestId", this.requestId).add("body", this.body()).toString();
    }
}

