/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public final class StreamRequest
extends AbstractMessage
implements RequestMessage {
    public final String streamId;

    public StreamRequest(String streamId) {
        this.streamId = streamId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.StreamRequest;
    }

    @Override
    public int encodedLength() {
        return Encoders.Strings.encodedLength(this.streamId);
    }

    @Override
    public void encode(ByteBuf buf) {
        Encoders.Strings.encode(buf, this.streamId);
    }

    public static StreamRequest decode(ByteBuf buf) {
        String streamId = Encoders.Strings.decode(buf);
        return new StreamRequest(streamId);
    }

    public int hashCode() {
        return Objects.hashCode(this.streamId);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamRequest) {
            StreamRequest o = (StreamRequest)other;
            return this.streamId.equals(o.streamId);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamId", this.streamId).toString();
    }
}

