/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import org.apache.spark.network.protocol.Encodable;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public final class StreamChunkId
implements Encodable {
    public final long streamId;
    public final int chunkIndex;

    public StreamChunkId(long streamId, int chunkIndex) {
        this.streamId = streamId;
        this.chunkIndex = chunkIndex;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeLong(this.streamId);
        buffer.writeInt(this.chunkIndex);
    }

    public static StreamChunkId decode(ByteBuf buffer) {
        assert (buffer.readableBytes() >= 12);
        long streamId = buffer.readLong();
        int chunkIndex = buffer.readInt();
        return new StreamChunkId(streamId, chunkIndex);
    }

    public int hashCode() {
        return Objects.hashCode(this.streamId, this.chunkIndex);
    }

    public boolean equals(Object other) {
        if (other instanceof StreamChunkId) {
            StreamChunkId o = (StreamChunkId)other;
            return this.streamId == o.streamId && this.chunkIndex == o.chunkIndex;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamId", this.streamId).add("chunkIndex", this.chunkIndex).toString();
    }
}

