/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.spark_project.guava.base.Objects;
import org.spark_project.io.netty.buffer.ByteBuf;

public final class OneWayMessage
extends AbstractMessage
implements RequestMessage {
    public OneWayMessage(ManagedBuffer body2) {
        super(body2, true);
    }

    @Override
    public Message.Type type() {
        return Message.Type.OneWayMessage;
    }

    @Override
    public int encodedLength() {
        return 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeInt((int)this.body().size());
    }

    public static OneWayMessage decode(ByteBuf buf) {
        buf.readInt();
        return new OneWayMessage(new NettyManagedBuffer(buf.retain()));
    }

    public int hashCode() {
        return Objects.hashCode(this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof OneWayMessage) {
            OneWayMessage o = (OneWayMessage)other;
            return super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("body", this.body()).toString();
    }
}

